########################################################################
#
# File Name: 		TimeStamp.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/TimeStamp.py.html
#
"""
Implements the TimeStamp interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
#"


from Ft.Ods import Date, TimeImp, Interval

SECS_IN_DAY = 3600*24

class TimeStamp:

    def __init__(self,db,data):

        if data is None:
            data = (0,0,0,0,0,0,0,0,0)
        elif len(data) == 2:
            data = map(lambda x:x[0],data[1])

        (year,month,day,hour,minute,seconds,milliseconds,tz_hour,tz_minute) = data
        
        from Ft.Ods import DateFactory,TimeFactory
        self._date = DateFactory.calendar_date(year,month,day)
        self._time = TimeImp.TimeImp(db,(hour,minute,seconds,milliseconds,tz_hour,tz_minute))

        self.value = self._date.value + self._time.value


    def get_date(self):
        return self._date

    def get_time(self):
        return self._time

    def year(self):
        return self._date.year()

    def month(self):
        return self._date.month()

    def day(self):
        return self._date.day()

    def hour(self):
        return self._time.hour()

    def minute(self):
        return self._time.minute()

    def second(self):
        return self._time.second()

    def millisecond(self):
        return self._time.millisecond()

    def tz_hour(self):
        return self._time.tz_hour()

    def tz_minute(self):
        return self._time.tz_minute()


    def plus(self,an_interval):

        nDate = self._date.add_days(an_interval.day())

        nInt = Interval.Interval(None,an_interval.value - an_interval.day()*SECS_IN_DAY)
        nTime = self._time.add_interval(nInt)
        return TimeStamp(None,(nDate.year(),
                               nDate.month(),
                               nDate.day(),
                               nTime.hour(),
                               nTime.minute(),
                               nTime.second(),
                               nTime.millisecond(),
                               self.tz_hour(),
                               self.tz_minute()))

    def minus(self,an_interval):
        nDate = self._date.subtract_days(an_interval.day())

        nInt = Interval.Interval(None,an_interval.value - an_interval.day()*SECS_IN_DAY)
        nTime = self._time.subtract_interval(nInt)
        return TimeStamp(None,(nDate.year(),
                               nDate.month(),
                               nDate.day(),
                               nTime.hour(),
                               nTime.minute(),
                               nTime.second(),
                               nTime.millisecond(),
                               self.tz_hour(),
                               self.tz_minute()))


    def is_equal(self,a_stamp):
        return self.value == a_stamp.value

    def is_greater(self,a_stamp):
        return self.value > a_stamp.value

    def is_greater_or_equal(self,a_stamp):
        return self.value >= a_stamp.value

    def is_less(self,a_stamp):
        return self.value < a_stamp.value

    def is_less_or_equal(self,a_stamp):
        return self.value <= a_stamp.value

    def is_between(self,a_stamp,b_stamp):
        return self.value >= a_stamp.value and self.value <= b_stamp.value

    def __str__(self):
        return "<TimeStamp at %x %s-%s-%s %s:%s:%s.%s>"% (id(self),self.year(),self.month(),self.day(),self.hour(),self.minute(),self.second(),self.millisecond())
    
    def __cmp__(self,other):
        if isinstance(other,TimeStamp):
            return not (self._date == other._date and self._time == other._time)
        return 1

    def _4ods_getData(self):
        return (None,self._date._4ods_getData()[1] + self._time._4ods_getData()[1])

    def _4ods_isModified(self):
        return 1
