



def RegisterExtensionModules(db,moduleList):

    res = []
    for m in moduleList:
        res.extend(RegisterExtensionModule(db,m))

    return res

def RegisterExtensionModule(db,mod):

    #Look for operation registration dict
    if hasattr(mod,'g_ftodsOperations'):
        return RegisterOperations(db,getattr(mod,'g_ftodsOperations'))
    return []

def RegisterOperations(db,opDict):

    repo = db.schema().resolve('ODLMetaObjects')
    res = []
    for name,func in opDict.items():
        op = repo.resolve(name)
        fileName = func.func_globals['__file__']
        if fileName[-3:] == 'pyc':
            fileName = fileName[:-1]
        db._4ods_registerOperation(op._4ods_getId(),func.func_name,fileName)


        res.append((name,op._4ods_getId(),func.func_name,fileName))
    return res
                  
