########################################################################
#
# File Name: 	        Structure.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Structure.py.html
#
"""
Implements the Structure meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.MetaData import ScopedType
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.MetaData import Member
from Ft.Ods.MetaData import MetaKind

from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Structure(ScopedType.ScopedType):
    def __init__(self,db, data):
        ScopedType.ScopedType.__init__(self,db, data,MetaKind.mk_structure)

    def add_fields(self,target,inverse = 1):
        self._4ods_addRelationship('fields',Member.Member,'structure_type','form',target,inverse)
    form_fields=add_fields

    def remove_fields(self,target,inverse = 1):
        self._4ods_removeRelationship('fields','structure_type','drop',target,inverse)
    drop_fields=remove_fields

    def form_exception_result(self,target,inverse = 1):
        from Ft.Ods.MetaData import Exception
        self._4ods_formRelationship('exception_result',Exception.Exception,'result','form',target,inverse)
    def drop_exception_result(self,target,inverse = 1):
        self._4ods_dropRelationship('exception_result','result','drop',target,inverse)


    def _4ods_getOdl(self,indent):
        st = indent + 'struct %s {\n' % self.name
        for m in self.fields:
            st = st + m._4ods_getOdl(indent + '  ') + ';\n'
        st = st + indent + '}'
        return st


    def _4ods_getBoundChildren(self):
        return self.fields
    def _4ods_boundChild(self,obj):
        self.add_fields(obj)
    def _4ods_unboundChild(self,obj):
        self.remove_fields(obj)

    def _4ods_checkRemove(self):
        return 1

    def _4ods_getOdmgType(self):
        return Constants.Types.STRUCTURE

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)
        found.append(self)
        for f in self.fields:
            f._4ods_getGeneratedMetaClasses(found,checked)
        return found

    def _4ods_findTypePath(self,object):
        for f in self.fields:
            if f == object:
                return [self,object]
            res = f._4ods_findTypePath(object)
            if res:
                return [self] + res
        return []


    
    _tupleNames =  (('fields',),('exception_result',),)

    _tupleDefinitions = {'fields':{td.TYPE:Constants.Types.LIST_COLLECTION,
                                   td.READONLY:1,
                                   td.RELATIONSHIP:1,
                                   td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                   },
                         'exception_result':{td.TYPE:Constants.Types.ROBJECT,
                                             td.READONLY:1,
                                             td.RELATIONSHIP:1,
                                             },
                         }
    _localExtents = ()
