########################################################################
#
# File Name: 	        Parameter.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Parameter.py.html
#
"""
Implements the Parameter meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.MetaData import Specifier
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.MetaData import Direction
from Ft.Ods.StorageManager.Adapters import Constants

from Ft.Ods.Exception import FtodsUnknownError

from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Parameter(Specifier.Specifier):
    def __init__(self,db, data,parameter_mode=None):
        Specifier.Specifier.__init__(self,db,data,MetaKind.mk_parameter)

        if data is None:
            if parameter_mode is None:
                raise FtodsUnknownError(msg="No Parameter Mode")
            self.__dict__['parameter_mode'] = parameter_mode

    def form_operation(self,target,inverse = 1):
        from Ft.Ods.MetaData import Operation
        self._4ods_formRelationship('operation',Operation.Operation,'signature','add',target,inverse)

    def drop_operation(self,target,inverse = 1):
        self._4ods_dropRelationship('operation','signature','remove',target,inverse)


    def _4ods_getOdl(self,indent):
        if self.parameter_mode == Direction.mode_in:
            st = 'in '
        elif self.parameter_mode == Direction.mode_out:
            st = 'out '
        else:
            st = 'inout '
        return st + '%s %s' % (self.type.absolute_name(),self.name)

    _tupleNames =  (('parameter_mode',),('operation',))

    _tupleDefinitions = {'parameter_mode':{td.TYPE:Constants.Types.ENUMERATION,
                                           td.LITERAL_REPO_ID:Direction.Direction._typeId,
                                           },
                         'operation':{td.TYPE:Constants.Types.ROBJECT,
                                      td.READONLY:1,
                                      td.RELATIONSHIP:1,
                                      },
                         }
    
    _localExtents = ()

