########################################################################
#
# File Name: 	       Operation.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Operation.py.html
#
"""
Implements the Operation meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.MetaData import MetaObject

from Ft.Ods.MetaData import Exception
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Operation(MetaObject.MetaObject):

    def __init__(self,db,data):
        MetaObject.MetaObject.__init__(self,db,data,MetaKind.mk_operation)



    def add_signature(self,target,inverse = 1):
        from Ft.Ods.MetaData import Parameter
        self._4ods_addRelationship('signature',Parameter.Parameter,'operation','form',target,inverse)
    form_signature = add_signature


    def remove_signature(self,target,inverse = 1):
        self._4ods_removeRelationship('signature','operation','drop',target,inverse)
    drop_signature=remove_signature

    def form_result(self,target,inverse = 1):
        from Ft.Ods.MetaData import Type
        self._4ods_formRelationship('result',Type.Type,'operations','add',target,inverse)
    def drop_result(self,target,inverse = 1):
        self._4ods_dropRelationship('result','operations','remove',target,inverse)

    

    def add_exceptions(self,target,inverse = 1):
        self._4ods_addRelationship('exceptions',Exception.Exception,'operations','add',target,inverse)
    form_exceptions=add_exceptions

    def remove_exceptions(self,target,inverse = 1):
        self._4ods_removeRelationship('exceptions','operations','remove',target,inverse)
    drop_exceptions=remove_exceptions



    def _4ods_checkRemove(self):
        return 1

    def _4ods_getOdl(self,indent):
        st = indent + "%s %s(" % (self.result.absolute_name() ,self.name)
        for p in self.signature:
            st = st + p._4ods_getOdl('') + ', '
        if len(self.signature):
            st = st [:-2] + ')'
        else:
            st = st + ')'
        if len(self.exceptions):
            st = st + ' raises ('
            for e in self.exceptions:
                st = st + e.absolute_name() + ', '
            st = st [:-2] + ')'
        return st

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)


    _tupleNames = (('signature',),('result',),('exceptions',))

    _tupleDefinitions = {'signature':{td.TYPE:Constants.Types.LIST_COLLECTION,
                                      td.READONLY:1,
                                      td.RELATIONSHIP:1,
                                      td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                     },
                         'result':{td.TYPE:Constants.Types.ROBJECT,
                                   td.READONLY:1,
                                   td.RELATIONSHIP:1,
                                   },
                         'exceptions':{td.TYPE:Constants.Types.LIST_COLLECTION,
                                       td.READONLY:1,
                                       td.RELATIONSHIP:1,
                                       td.COLLECTION_SUBTYPE:Constants.Types.ROBJECT,
                                       },
                         }

    _localExtents = ()
