########################################################################
#
# File Name: 	       Operand.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Operand.py.html
#
"""
Implements the Operand meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import RepositoryObject
from Ft.Ods.StorageManager.Adapters import Constants

from Ft.Ods.Exception import FtodsUnknownError

from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Operand(RepositoryObject.RepositoryObject):
    def __init__(self,db,data,meta_kind):
        RepositoryObject.RepositoryObject.__init__(self,db,data,meta_kind)

    def value(self):
        raise FtodsUnknownError("Must be overridden in %s" % str(self))

    def form_operand_in(self,target,inverse=1):
        from Ft.Ods.MetaData import Expression
        self._4ods_formRelationship('operand_in',Expression.Expression,'the_operands','add',target,inverse)

    def drop_operand_in(self,target,inverse=1):
        self._4ods_dropRelationship('operand_in','the_operands','remove',target,inverse)

    def form_value_of(self,target,inverse = 1):
        from Ft.Ods.MetaData import Constant
        self._4ods_formRelationship('value_of',Constant.Constant,'the_Value','form',target,inverse)

    def drop_value_of(self,target,inverse=1):
        self._4ods_dropRelationship('value_of','the_Value','drop',target,inverse)


    def form_size_of(self, target, inverse=1):
        from Ft.Ods.MetaData import Collection
        self._4ods_formRelationship('size_of',Collection.Collection,'max_size','form',target,inverse)

    def drop_size_of(self, target, inverse=1):
        self._4ods_dropRelationship('size_of','max_size','drop',target,inverse)
    
    def form_case_in(self,target,inverse = 1):
        from Ft.Ods.MetaData import UnionCase
        self._4ods_formRelationship('case_in',UnionCase.UnionCase,'case_labels','add',target,inverse)

    def drop_case_in(self,target,inverse=1):
        self._4ods_dropRelationship('case_in','case_labels','remove',target,inverse)




    _tupleNames = (('operand_in',),('value_of',),('size_of',),('case_in',))

    _tupleDefinitions = {'operand_in':{td.TYPE:Constants.Types.ROBJECT,
                                       td.RELATIONSHIP:1,
                                       td.READONLY:1
                                       },
                         'value_of':{td.TYPE:Constants.Types.ROBJECT,
                                     td.RELATIONSHIP:1,
                                     td.READONLY:1
                                     },
                         'size_of':{td.TYPE:Constants.Types.ROBJECT,
                                    td.READONLY:1,
                                    td.RELATIONSHIP:1,
                                    },

                         'case_in':{td.TYPE:Constants.Types.ROBJECT,
                                    td.READONLY:1,
                                    td.RELATIONSHIP:1,
                                    },
                         }
    _localExtents = ()
