########################################################################
#
# File Name: 	        Module.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Module.py.html
#
"""
Implements the Module meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import MetaObject
from Ft.Ods.MetaData import DefiningScope
from Ft.Ods.MetaData import MetaKind

class Module(MetaObject.MetaObject, DefiningScope.DefiningScope):
    def __init__(self,db,data,meta_kind=None):
        if meta_kind is None:
            meta_kind = MetaKind.mk_module
        MetaObject.MetaObject.__init__(self, db,data,meta_kind)
        DefiningScope.DefiningScope.__init__(self)

    def add_module(self,name):
        m = Module(self._db,None)
        m.name = name
        self.bind(name,m)
        return m

    def add_interface(self,name, inherits):
        from Ft.Ods.MetaData import Interface
        i = Interface.Interface(self._db,None)
        i.name = name
        if inherits:
            for inherit in inherits:
                i.add_inherits(inherit)
        self.bind(name,i)
        return i

    def add_class(self,name,inherits,extender):
        from Ft.Ods.MetaData import Class
        c = Class.Class(self._db,None)
        c.name = name
        if inherits:
            for inherit in inherits:
                c.add_inherits(inherit)
        if extender:
            c.form_extender(extender)
        self.bind(name,c)
        return c

    def remove_module(self,mod):
        if not mod._4ods_checkRemove():
            raise DefiningScope.CannotRemove(reason='Failed Remove Check')
        self.remove_defines(mod)
        mod.delete()

    def remove_interface(self,i):
        if not i._4ods_checkRemove():
            raise DefiningScope.CannotRemove(reason='Failed Remove Check')
        for inherits in i.inherits:
            i.remove_inherits(inherits)
        self.remove_defines(i)
        i.delete()

    def remove_class(self,c):
        if not c._4ods_checkRemove():
            raise DefiningScope.CannotRemove(reason='Failed Remove Check')
        for inherits in c.inherits:
            c.remove_inherits(inherits)
        if c.extender:
            c.drop_extender(c.extender)
        self.remove_defines(c)
        c.delete()


    def _4ods_getOdl(self,indent = ''):
        st = indent + 'module %s {\n' % self.name
        for d in self.defines:
            if d.meta_kind == MetaKind.mk_interface:
                st = st + indent + '  interface %s;\n' % d.absolute_name()
            if d.meta_kind == MetaKind.mk_class:
                st = st + indent + '  class %s;\n' % d.absolute_name()
        for d in self.defines:
            st = st + '%s;\n' % d._4ods_getOdl(indent+'  ')
        st = st + indent + '}%s' % (indent == '' and ';\n' or '')
        return st



    def _4ods_checkRemove(self):
        return 1


    def _4ods_getGeneratedMetaClasses(self,found = None,checked = None):
        if found is None:
            found = []
        if checked is None:
            checked = []
        if self in checked: return found
        checked.append(self)

        if self.name != 'ODLMetaObjects':
            found.append(self)
        for d in self.defines:
            d._4ods_getGeneratedMetaClasses(found,checked)
        return found

    def _4ods_findTypePath(self,object):
        for d in self.defines:
            if d == object:
                return [self,object]
            res = d._4ods_findTypePath(object)
            if res:
                return [self] + res
        return []


    _tupleNames = ()
    _tupleDefs = {}
    _localExtents = ()
    
