########################################################################
#
# File Name: 	        ConstOperand.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/ConstOperand.py.html
#
"""
Implements the ConstOperand meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods.MetaData import Operand
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager.Adapters import Constants

from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions


class ConstOperand(Operand.Operand):
    def __init__(self,db,data):
        Operand.Operand.__init__(self,db,data,MetaKind.mk_const_operand)


    def value(self):
        if self.references:
            return self.references.value()
        return None

    def form_references(self,target,inverse = 1):
        from Ft.Ods.MetaData import Constant
        self._4ods_formRelationship('references',Constant.Constant,'referenced_by','add',target,inverse)
    def drop_references(self,target,inverse = 1):
        self._4ods_dropRelationship('references','referenced_by','remove',target,inverse)


    def _4ods_getOdl(self,indent):
        return indent + self.__dict__['references'].name


    _tupleNames =  (('references',),)

    _tupleDefinitions = {'references':{td.TYPE:Constants.Types.ROBJECT,
                                        td.READONLY:1,
                                        td.RELATIONSHIP:1,
                                       },
                         }

    _localExtents = ()


