############################################################################
#
# File Name: 		SetBase.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/SetBase.py.html
#
"""
Sets: collections disallowing duplicates.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.Collections import CollectionBase


class SetBase:

    _collectionType = Constants.CollectionTypes.SET


    def is_ordered(self):
        return 0

    def allows_duplicates(self):
        return 0

    def create_union(self, other_set):
        result = self.copy(deep=0)
        for item in other_set:
            if self.contains_element(item):
                result.insert_element(item)
        return result

    def create_intersection(self, other_set):
        result = self.copy(deep=1)
        for item in other_set:
            if not result.contains_element(item):
                CollectionBase.CollectionBase.insert_element(result,item)
        return result

    def create_difference(self, other_set):
        result = self.copy(deep=0)
        for item in other_set:
            if not item in self:
                CollectionBase.CollectionBase.insert_element(result,item)
        for item in self:
            if not other_set.contains_element(item):
                CollectionBase.CollectionBase.insert_element(result,item)
        return result

    def is_subset_of(self, other_set):
        for item in self:
            if not other_set.contains_element(item):
                return 0
        return 1

    def is_superset_of(self, other_set):
        return other_set.is_subset_of(self)

    def is_proper_subset_of(self,other_set):
        return self.is_subset_of(other_set) and (self.cardinality() != other_set.cardinality())

    def is_proper_superset_of(self,other_set):
        return other_set.is_proper_subset_of(self)



    def insert_element(self,item):
        if self.contains_element(item):
            return
                #Figure out which base class to use
        return CollectionBase.CollectionBase.insert_element(self,item)

    def _4ods_getOdsType(self):
        return Constants.Types.SET_COLLECTION
