#ifndef EXPAT2DOMLETTE
#define EXPAT2DOMLETTE
#include <stdio.h>
#include "Python.h"
#include "xmlparse.h"
#include "domlette.h"
#include "ds_primitives.h"

#define NSSEP '\t'

typedef struct UniversalName_ {
  XML_Char *prefix;
  XML_Char *uri;
  XML_Char *local;
} UniversalName;


typedef struct StripSpec_ {
  XML_Char *uri;
  XML_Char *local;
  int strip_flag;
} StripSpec;


typedef struct State_ {
  Stack *preserve_state;
  PyNodeObject *rootNode;
  PyDocumentObject *ownerDoc;

  Stack *node_stack;
  List *new_nss;
  List *namespaces;
  XML_Char *curr_text;
  StripSpec *strip_elements;
  int num_strip_elements;
  unsigned long *docIx;
} State;


typedef struct NsMapping_ {
  XML_Char *uri;
  XML_Char *prefix;
} NsMapping;


PyDocumentObject *beginParse(FILE *, PyObject *, StripSpec *stripElements,
                             int numStripElements, const char *refUri);

#endif
