"""
Threading abstraction which allows for :mod:`threading2` use with a
transparent fallback to :mod:`threading` when it is not available.
Pyro doesn't use :mod:`threading` directly: it imports all
thread related items via this module instead. Code using Pyro can do
the same (but it is not required).

Pyro - Python Remote Objects.  Copyright by Irmen de Jong (irmen@razorvine.net).
"""

from Pyro4 import config

if config.THREADING2:
    try:
        from threading2 import *
    except ImportError:
        from threading import *
else:
    from threading import *


class AtomicCounter(object):
    def __init__(self, value=0):
        self.__initial = value
        self.__value = value
        self.__lock = Lock()

    def reset(self):
        self.__value = self.__initial

    def incr(self, amount=1):
        with self.__lock:
            self.__value += amount
            return self.__value

    def decr(self, amount=1):
        with self.__lock:
            self.__value -= amount
            return self.__value

    @property
    def value(self):
        return self.__value
