# File: outbox.py
# Purpose: outbox. duh

import utils

from gtk import *
import time
import os.path
import string

import boxformats
from boxformats import *
import boxformats.configbox
import boxtypes
from pyneheaders import *
import pynemsg
from boxtypes.superbox import *
from ptk.big_edit_box import *

class outbox(superbox):
	"""
	General outbox for nntp or smtp outgoing mail.
	"""
	def get_flags(self):
		return BOX_DEL_MESSAGE | BOX_UPDATE_METHOD

	def __init__(self, user, name, uid):
		"""
		Configure an smtp outbox.
		"""
		# Set defaults
		superbox.__init__(self, name, uid)
		self.messages = []
		self.export_format = (boxformats.BF_FLATFILEBOX, None)
		self.startup(user)

	def clean_4_save(self):
		"""
		Remove stuff we don't want saved to disk
		"""
		if self.__dict__.has_key("locked"):
			del self.locked
		if self.__dict__.has_key("changed"):
			del self.changed
		del self.io
		del self.messages

	def startup(self, user):
		"""
		Get an io module for loading/saving articles
		"""
		i = self.export_format[0]

		# this is a pretty piece of code :-)
		bf_class = boxformats.__dict__[boxformats.__all__[i]]. \
			   __dict__[boxformats.__all__[i]]
		self.io = bf_class(user, self)
		self.messages = self.io.get_contents()

	def new_message(self, user, from_folder, type, to=""):
		"""
		Create and edit a new outgoing message from 'folder'.
		"""
		new = pynemsg.pynemsg()
	
		new.date = time.gmtime(time.time())
		# send with this folder's settings
		new.senduid = from_folder.uid
		# create some basic headers:
		new.headers = {}
	
		if type == REPLY_GROUP:
			# news postings:
			new.headers["newsgroups"] = to
			if from_folder.replyto != "":
				new.headers["reply-to"] = from_folder.replyto
		else:
			# email message
			new.headers["to"] = to
			if from_folder.replyto != "":
				new.headers["reply-to"] = from_folder.replyto
			new.headers["cc"] = ""
		# universal headers
		new.headers["message-id"] = self.io.get_unique_message_id()
		new.headers["subject"] = ""
		if from_folder.org != "":
			new.headers["organization"] = from_folder.org
		if from_folder.realname != "":
			new.headers["from"] = "\""+from_folder.realname+"\" <"+from_folder.emailaddr+">"
		else:
			new.headers["from"] = from_folder.emailaddr
		
		if from_folder.sigfile == "":		
			new.parts_text.append("\n")
		else:
			try:
				# Open and append sigfile
				f = open(os.path.expanduser(from_folder.sigfile), "r")
			except IOError:
				# Failure
				utils.info_box(_("Error"), _("Error opening sigfile..."), _("Ok"))
				new.parts_text.append("\n")
			else:
				new.parts_text.append("\n\n\n-- \n")
				while 1:
					line = f.readline()
					if line == "":
						break
					else:
						new.parts_text[0] = new.parts_text[0] + line
		new.parts_header.append(new.headers)

		# Shove in outbox
		self.messages.append(new.headers["message-id"])
		new.make_source()
		self.io.save_article(new)
		self.changed = 1
		user.update()
		new.edit(self, user, is_new_msg=1)

	def do_reply(self, user, msg, from_folder, type=REPLY_AUTO):

		# Compare folders with this to make sure they are
		# suitable boxes to send mail with
		def compare_mailbox(box):
			if isinstance(box, boxtypes.mailbox.mailbox):
				if box.send_type != mail_send.MAIL_SEND_NONE:
					return 1
			return 0
		
		if type==REPLY_AUTO:
			# Select most appropriate option for message type
			if isinstance(from_folder, boxtypes.nntpbox.newsgroup):
				# need to find the nntpbox parent box
				parent_folder = user.parent_of(from_folder)
				self._reply(user, from_folder, parent_folder, msg, REPLY_GROUP)
				return
				
			elif isinstance(from_folder, boxtypes.mailbox.mailbox):
				self._reply(user, from_folder, from_folder, msg, REPLY_EMAIL)
				return
	
		if type==REPLY_EMAIL:
			if isinstance(from_folder, boxtypes.nntpbox.newsgroup):
				# Replying to an NNTP message by mail. Get a mailbox to use
				def ok_click(folder, self=self, from_folder=from_folder, user=user, msg=msg):
					self._reply(user, from_folder, folder, msg, REPLY_EMAIL)
				utils.UserChooseBox(user, compare_mailbox, ok_click, _("Pyne - Select a mailbox"))
				return
	
			elif isinstance(from_folder, boxtypes.mailbox.mailbox):
				self._reply(user, from_folder, from_folder, msg, REPLY_EMAIL)
				return
			
		if type==REPLY_GROUP:
			if isinstance(from_folder, boxtypes.nntpbox.newsgroup):
				# need to find the nntpbox parent box
				parent_folder = user.parent_of(from_folder)
				self._reply(user, from_folder, parent_folder, msg, REPLY_GROUP)
				return
			elif isinstance(from_folder, boxtypes.mailbox.mailbox):
				self._reply(user, from_folder, from_folder, msg, REPLY_CC)
				return

		if type==REPLY_FORWARD:
			if isinstance(from_folder, boxtypes.nntpbox.newsgroup):
				# Forwarding an NNTP message by mail. Get a mailbox to use
				def ok_click(folder, self=self, user=user, msg=msg):
					self._reply(user, from_folder, folder, msg, REPLY_FORWARD)
				utils.UserChooseBox(user, compare_mailbox, ok_click, _("Pyne - Select a mailbox"))

			elif isinstance(from_folder, boxtypes.mailbox.mailbox):
				self._reply(user, from_folder, from_folder, msg, REPLY_FORWARD)


	def _reply(self, user, from_folder, reply_folder, msg, type, send_to="", dont_open_editbox=0):
		"""
		Reply to message. type is method of reply. see REPLY_ in
		message.py. Original message is in from_folder, send using
		reply_folder.
		"""
		# Mark message as replied (not forwarded)
		if type != REPLY_FORWARD:
			msg.opts = msg.opts | MSG_ISREPLIED
			from_folder.io.save_article(msg)
			from_folder.changed = 1
			
		# Create new message
		old = msg
		new = pynemsg.pynemsg()

		# send with this folder's settings
		new.senduid = reply_folder.uid
		# create some basic headers:
		new.headers = {}
		new.date = time.gmtime(time.time())

		if reply_folder.replyto != "":
			new.headers["reply-to"] = reply_folder.replyto

		if old.headers.has_key("newsgroups") and type == REPLY_GROUP:
			new.headers["newsgroups"] = old.headers["newsgroups"]
		# email message
		else:
			if type != REPLY_FORWARD:
				if old.headers.has_key("reply-to"):
					new.headers["to"] = old.headers["reply-to"]
				else:
					try:
						new.headers["to"] = old.headers["from"]
					except KeyError:
						new.headers["to"] = send_to
			else:
				new.headers["to"] = send_to
				
			if type == REPLY_CC and old.headers.has_key("cc"):
				new.headers["cc"] = old.headers["cc"]
			else:
				new.headers["cc"] = ""
		# universal headers
		new.headers["message-id"] = self.io.get_unique_message_id()
		if type == REPLY_FORWARD:
			new.headers["subject"] = "Fwd: "+old.headers["subject"]
		else:
			if string.lower(old.headers["subject"][:3]) == "re:":
				new.headers["subject"] = old.headers["subject"]
			else:
				new.headers["subject"] = "Re: "+old.headers["subject"]
		if reply_folder.org != "":
			new.headers["organization"] = reply_folder.org
		if reply_folder.realname != "":
			new.headers["from"] = "\""+reply_folder.realname+"\" <"+reply_folder.emailaddr+">"
		else:
			new.headers["from"] = reply_folder.emailaddr
		if old.headers.has_key("references"):
			new.headers["references"] = old.headers["references"]+" "+old.headers["message-id"]
		else:
			new.headers["references"] = old.headers["message-id"]
				
		# Copy body
		new.body = ""
		new.parts_text.append(old.parts_text[0])
		# Strip other guys sig (if not forwarding)
		if type != REPLY_FORWARD:
			x = string.find(new.parts_text[0], "\n-- \n")
			if x != -1:
				new.parts_text[0] = new.parts_text[0][0:x]
		new.parts_header.append(old.headers)
		# Put quote '> ' things in
		lines = string.split(new.parts_text[0], "\n")
		# check no lines are 
		i = 0
		for x in lines:
			if len(x) > user.linewrap*2:
				y = string.find(x[:user.linewrap], " ")
				# break here
				lines.insert(i+1, x[user.linewrap+y+1:])
				lines[i] = lines[i][:user.linewrap+y]
			i = i + 1
		new.parts_text[0] = "> "+string.join(lines, "\n> ")

		if reply_folder.sigfile != "":		
			try:
				# Open and append sigfile
				f = open(os.path.expanduser(reply_folder.sigfile), "r")
			except IOError:
				# Failure
				utils.info_box(_("Error"), _("Error opening sigfile:\n%s") % reply_folder.sigfile, _("Ok"))
			else:
				new.parts_text[0] = new.parts_text[0]+"\n\n\n-- \n"
				while 1:
					line = f.readline()
					if line == "":
						break
					else:
						new.parts_text[0] = new.parts_text[0] + line
		# Reply note
		reply_note = string.replace(user.replyhead, "$DATE", time.strftime("%d %b %Y, %H:%M:%S", old.date))
		reply_note = string.replace(reply_note, "$FROM", utils.split_address(old.headers["from"])[0])
		new.parts_text[0] = reply_note + "\n" + new.parts_text[0]
		if type == REPLY_FORWARD:
			if old.headers.has_key("newsgroups"):
				new.parts_text[0] = "To: "+old.headers["newsgroups"]+"\n"+new.parts_text[0]
			new.parts_text[0] = "From: "+old.headers["from"]+"\n"+new.parts_text[0]
			new.parts_text[0] = "----------  "+_("Forwarded Message")+"  ----------\n"+new.parts_text[0]
		new.date = time.gmtime(time.time())
		# Shove in outbox
		self.messages.append(new.headers["message-id"])
		new.make_source()
		self.io.save_article(new)
		self.changed = 1
		user.update()
		if dont_open_editbox == 0:
			if type == REPLY_FORWARD:
				new.edit(self, user, is_new_msg=1)
			else:
				new.edit(self, user, is_new_msg=1)

	def getstats(self):
		"""
		Returns total unsend msgs.
		"""
		return (len(self.messages),)

	def get_menu(self):
		"""
		This box type specific options.
		"""
		return []

	def menu_chosen(self, _a, choice):
		"""
		Activate the chosen menu option.
		"""
		return

	def update(self, user, pager):
		"""
		Sends all the messages in the outbox.
		"""
		self.locked = 1

		threads_enter()
		progressbar = pager.get_progress_bar()
		progressbar.set_format_string(_("0/%d outgoing messages posted") % len(self.messages))
		threads_leave()

		# load messages
		msgs = []
		for x in self.messages:
			# rebuild body without dummy message id
			msg = self.io.load_article(x)
			msg.make_source(presend=1)
			msgs.append(msg)
		# sort messages by uid into seperate dict entries
		msg_by_box = {}
		for x in msgs:
			if msg_by_box.has_key(x.senduid):
				msg_by_box[x.senduid].append(x)
			else:
				msg_by_box[x.senduid] = []
				msg_by_box[x.senduid].append(x)

		# send them
		self.__post_msgs(msg_by_box, user, pager, progressbar)

		del self.locked

	def send_one(self, user, pager, msg_id):
		"""
		Only send messagee 'msg_id'.
		"""
		self.locked = 1

		threads_enter()
		progressbar = pager.get_progress_bar()
		progressbar.set_format_string(_("%d/%d outgoing messages posted") % (0,1))
		threads_leave()

		# load message
		msg = self.io.load_article(msg_id)
		msg.make_source(presend=1)
		# sort messages by uid into seperate dict entries
		msg_by_box = { msg.senduid: [ msg ] }

		# send it
		self.__post_msgs(msg_by_box, user, pager, progressbar)

		del self.locked

	def __post_msgs(self, msg_by_box, user, pager, progressbar):
		"""
		Sends all the messages in the outbox.
		msg_by_box is a dictionary. keys are uids of sending boxes,
		contents of each a list of message bodies to be sent with that box.
		"""
		sent_list = [] # list of message-ids sucessfully sent

		# go through box uids sending messages.
		i = 0
		total = 0
		for x in msg_by_box.keys():
			for y in msg_by_box[x]:
				total = total + 1
			sendbox = user.get_folder_by_uid(x)
			# The sendbox has been deleted since this message was created :-(
			if sendbox == None:
				usermsg = _("Send box not found posting message \'%s\'") % y.headers["subject"]
				threads_enter()
				pager.msg_print(usermsg)
				progressbar.set_format_string(usermsg)
				threads_leave()
				continue
				
			# should check for failure...
			threads_enter()
			pager.msg_print(_("Outgoing: Connecting to server (%s)...") % sendbox.name)
			threads_leave()
			try:
				c = sendbox.get_connection()
			except Exception, e:
				# Dirty catch-all
				msg = _("Outgoing: Error:")+" <%s> " % sendbox.name + `e.args[:1]`
				threads_enter()
				pager.msg_print(msg)
				threads_leave()
				continue
			# send messages
			for y in msg_by_box[x]:
				try:
					sendbox.post_message(c, y)
					sent_list.append(y.headers["message-id"])
				except:
					usermsg = _("Send error posting message \'%s\'") % y.headers["subject"]
					threads_enter()
					pager.msg_print(usermsg)
					progressbar.set_format_string(usermsg)
					threads_leave()
				else:
					i = i + 1
					threads_enter()
					progressbar.set_percentage(i/float(len(self.messages)))
					progressbar.set_format_string(_("%d/%d outgoing messages posted") % (i, len(self.messages)))
					threads_leave()
			c.quit()

		usermsg = _("%d/%d outgoing messages posted") % (len(sent_list), total)
		threads_enter()
		pager.msg_print(usermsg)
		progressbar.set_percentage(0.0)
		progressbar.set_format_string(usermsg)
		progressbar.set_sensitive(FALSE)
		threads_leave()

		# Remove sent messages, appending to sent mail and setting
		# date as when sent.
		sentbox = user.get_folder_by_uid("sent")
		for x in sent_list:
			msg = self.io.load_article(x)
			self.messages.remove(x)
			self.io.delete_article(x)
			sentbox.messages.append(x)
			msg.opts = msg.opts | MSG_SENT
			msg.date = time.gmtime(time.time())
			sentbox.io.save_article(msg)

			sentbox.changed = 1
			self.changed = 1

		threads_enter()
		user.update()
		threads_leave()

	def setup(self, parent_user):
		"""
		Configure an outbox.
		"""
		win = GtkWindow()
		win.set_title(_("%s Setup") % self.name)

		box = GtkVBox()
		win.add(box)
		box.show()

		notebook = GtkNotebook()
		notebook.set_tab_pos(POS_TOP)
		box.pack_start(notebook)
		notebook.show()
	
		# First page: Misc settings
		settings_box = big_edit_box(self,
		      ( ("name", "Name:", VAR_TYPE_STRING, 0, 0), )
		)
		label = GtkLabel(_("Settings"))
		notebook.append_page(settings_box, label)
		settings_box.show()

		# 2nd page: storage method
		label = GtkLabel(_("Mailbox Format"))
		formatbox = boxformats.configbox.configbox(self, parent_user)
		notebook.append_page(formatbox, label)
		formatbox.show()

		def save_changes(_button, self=self, parent_user=parent_user, win=win, \
			settings_box=settings_box):
			# Extract info
			settings_box.apply_changes()
			# update folder list
			self.changed = 1
			parent_user.update()
			win.destroy()

		# Seperator between entry boxes and buttons
		separator = GtkHSeparator()
		box.pack_start(separator, expand=FALSE)
		separator.show()

		# Buttons at bottom
		lastbox = GtkHBox(spacing=5)
		lastbox.set_border_width(10)
		box.pack_start(lastbox, expand=FALSE)
		lastbox.show()

		cancel_button = GtkButton(" "+_("Cancel")+" ")
		cancel_button.connect("clicked", win.destroy)
		lastbox.pack_end(cancel_button, expand=FALSE)
		cancel_button.show()

		ok_button = GtkButton(" "+_("Ok")+" ")
		ok_button.connect("clicked", save_changes)
		lastbox.pack_end(ok_button, expand=FALSE)
		ok_button.show()

		win.show()

