# A mail collector thingy using pop3
from gtk import *

import poplib
import string
import recv
from ptk.big_edit_box import *
import pynei18n

class pop3_recv:
	def __init__(self, conf):
		self.conf = conf
		self.connection = poplib.POP3(conf["server"], conf["port"])
	
	def close_connection(self):
		self.connection.quit()
	
	def auth(self):
		try:
			if self.conf["username"] != "":
				self.connection.user(self.conf["username"])
			if self.conf["password"] != "":
				self.connection.pass_(self.conf["password"])
		except poplib.error_proto:
			raise recv.auth_exception

	def get_msg_list(self):
		"""
		Return dict of message ids in form:
		{ 'msg1_id': msg1_size, 'msg2_id': msg2_size, ... }
		"""
		raw_list = self.connection.list()[1]
		y = {}
		for i in raw_list:
			id, size = string.split(i)
			y[id] = int(size)
		return y

	def get_header(self, index):
		lines = self.connection.top(index, 0)[1]
		head = string.join(lines, "\n")
		return head

	def get_body(self, index):
		lines = self.connection.retr(index)[1]
		body = string.join(lines, "\n")
		start = string.find(body, "\n\n") + 2
		return body[start:]

	def delete_msg(self, index):
		self.connection.dele(index)

def fix_defaults(conf):
	conf["port"] = 110

def get_connection(conf):
	"""
	return a connection object thingy.
	"""
	return pop3_recv(conf)

def setup(parent_mailbox, conf):
	"""
	Open a configuration dialog box.
	"""
	win = GtkWindow()
	win.set_title("%s POP3 Settings" % parent_mailbox.name)

	box = GtkVBox()
	box.set_border_width(5)
	win.add(box)
	box.show()

	# dummy class object for settings
	class _dummy:
		pass
	settings = _dummy()
	settings.__dict__ = conf

	settings_box0 = big_edit_box( settings,
	      ( ("server", _("POP3 server:"), VAR_TYPE_STRING, 0, 0),
		("port", _("Port:"), VAR_TYPE_INTEGER, 0, 110),
		("username", _("Username:"), VAR_TYPE_STRING, 0, 0),
		("password", _("Password:"), VAR_TYPE_STRING, MOD_HIDE, 0) )
	)
	box.pack_start(settings_box0, expand=FALSE)
	settings_box0.show()

	# separator between entry boxes and buttons
	separator = GtkHSeparator()
	box.pack_start(separator, expand=FALSE)
	separator.show()

	def save_changes(_button, win=win, settings=settings, settings_box0=settings_box0):
		# Extract info
		settings_box0.apply_changes()
		win.destroy()

	# boootons
	buttonbox = GtkHBox(spacing=5)
	buttonbox.set_border_width(5)
	box.pack_start(buttonbox, expand=FALSE)
	buttonbox.show()

	cancel_button = GtkButton(" "+_("Cancel")+" ")
	cancel_button.connect("clicked", win.destroy)
	buttonbox.pack_end(cancel_button, expand=FALSE)
	cancel_button.show()

	ok_button = GtkButton(" "+("Ok")+" ")
	ok_button.connect("clicked", save_changes)
	buttonbox.pack_end(ok_button, expand=FALSE)
	ok_button.show()

	win.show()

	
