/*
 * Pspell interface header file
 * Copyright 2000 by Kevin Atkinson under the terms of the LGPL
 *
 */

#ifndef PSPELL_STRING_PAIR_EMULATION__H
#define PSPELL_STRING_PAIR_EMULATION__H

#include "string_pair.h"

#ifdef __cplusplus

  class PspellStringPairEmulation {
  public:
    virtual PspellStringPairEmulation * clone() const = 0;
    virtual void assign(const PspellStringPairEmulation *) = 0;
    virtual bool at_end() const = 0;
    virtual PspellStringPair next() = 0;
  }; 

#else

  typedef struct PspellStringPairEmulation PspellStringPairEmulation;

#endif

#ifdef __cplusplus
extern "C" {
#endif

  PspellStringPairEmulation * 
    pspell_string_pair_emulation_clone
      (const PspellStringPairEmulation *);

  void pspell_string_pair_emulation_assign
      (PspellStringPairEmulation *, 
       const PspellStringPairEmulation *);
  
  int pspell_string_pair_emulation_at_end
      (const PspellStringPairEmulation *);

  PspellStringPair pspell_string_pair_emulation_next
      (PspellStringPairEmulation *);

  void delete_pspell_string_pair_emulation
      (PspellStringPairEmulation *);

#ifdef __cplusplus
}
#endif

#endif
