/*
 * Pspell interface header file
 * Copyright 2000 by Kevin Atkinson under the terms of the LGPL
 *
 */

#ifndef PSPELL_STRING_MAP__H
#define PSPELL_STRING_MAP__H

#include "mutable_container.h"
#include "string_pair_emulation.h"

#ifdef __cplusplus
  class PspellStringMap : public PspellMutableContainer {
  public:
    virtual PspellStringMap * clone() const = 0;
    virtual void assign(const PspellStringMap *) = 0;
    
    virtual PspellStringPairEmulation * elements() const = 0;
    
    // insert a new element.   Will NOT overright an existing entry.
    // returns false if the element already exists.
    virtual bool insert(const char * key, const char * value) = 0;
    
    // insert a new element. WILL overight an exitsing entry
    // always returns true
    virtual bool replace(const char * key, const char * value) = 0;
    
    // looks up an element.  Returns null if the element did not exist.
    // returns an empty string if the element exists but has a null value
    // otherwise returns the value
    virtual const char * lookup(const char * key) const = 0;

    virtual bool have(const char * key) const = 0;
    
    virtual unsigned int size() const = 0;
    virtual bool empty() const = 0;

    virtual ~PspellStringMap() {}
  };
#else 
  typedef struct PspellStringMap PspellStringMap;
#endif

#ifdef __cplusplus
extern "C" {
#endif

  PspellStringMap * new_pspell_string_map();

  void delete_pspell_string_map(PspellStringMap *);
  

  PspellStringMap * pspell_string_map_clone(const PspellStringMap *);

  void pspell_string_map_assign(PspellStringMap *, const PspellStringMap *);
  
  PspellStringPairEmulation * 
    pspell_string_map_elements (const PspellStringMap *);
  
  int pspell_string_map_insert(PspellStringMap *, 
			       const char * key, 
			       const char * value);
  
  int pspell_string_map_replace(PspellStringMap *, 
				const char * key, 
				const char * value);

  int pspell_string_map_remove(PspellStringMap *, 
			       const char * key);
  
  void pspell_string_map_clear(PspellStringMap *);

  const char * pspell_string_map_lookup(const PspellStringMap *, 
					const char * key);

  unsigned int pspell_string_map_size(const PspellStringMap *);
  
  int pspell_string_map_empty(const PspellStringMap *);
  
  
#ifdef __cplusplus
}
#endif


#endif
