// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#include "string_map.h"

PspellStringMap * pspell_string_map_clone(const PspellStringMap * ths) 
{
  return ths->clone();
}

void pspell_string_map_assign(PspellStringMap * ths, 
			      const PspellStringMap * other) 
{
  ths->assign(other);
}

PspellStringPairEmulation * 
  pspell_string_map_elements (const PspellStringMap * ths)
{
  return ths->elements();
}

int pspell_string_map_insert(PspellStringMap * ths, 
			     const char * key, 
			     const char * value)
{
  return ths->insert(key,value);
}

int pspell_string_map_replace(PspellStringMap * ths, 
			      const char * key, 
			      const char * value)
{
  return ths->replace(key,value);
}

int pspell_string_map_remove(PspellStringMap * ths, 
			     const char * key)
{
  return ths->remove(key);
}

void clear_pspell_string_map(PspellStringMap * ths) 
{
  ths->clear();
}

const char * pspell_string_map_lookup(const PspellStringMap * ths, 
				      const char * key)
{
  return ths->lookup(key);
}

unsigned int pspell_string_map_size(const PspellStringMap * ths)
{
  return ths->size();
}

int pspell_string_map_empty(const PspellStringMap * ths)
{
  return ths->empty();
}

void delete_pspell_string_map(PspellStringMap * ths)
{
  delete ths;
}
