/*
 * Pspell interface header file
 * Copyright 2000 by Kevin Atkinson under the terms of the LGPL
 *
 */

#ifndef PSPELL_STRING_MAP__H
#define PSPELL_STRING_MAP__H

#ifdef __cplusplus

class PspellStringList : public PspellMutableContainer {
  virtual PspellStringList * clone() const = 0;
  virtual void assign(const PspellStringList *) = 0;

  virtual bool have(const char * key) const = 0;

  virtual PspellStringEmulation * elements() const = 0;

  virtual unsigned int size() const = 0;
  virtual bool empty() const = 0;
};

#else 
  typedef struct PspellStringList PspellStringList;
#endif

#ifdef __cplusplus
extern "C" {
#endif

  PspellStringList * new_pspell_string_list();

  void delete_pspell_string_list(PspellStringList *);

  PspellStringList * pspell_string_list_clone(const PspellStringList *);

  void pspell_string_list_assign(PspellStringList *, const PspellStringList *);
  
  PspellStringEmulation     * 
    pspell_string_list_elements (const PspellStringList *);

  int pspell_string_list_have(PspellStringList *, const char * key);
  
  int pspell_string_list_add(PspellStringList *, const char * key);
  
  int pspell_string_list_remove(PspellStringList *, const char * key);
  
  void pspell_string_list_clear(PspellStringList *);

  unsigned int pspell_string_list_size(const PspellStringList *);
  
  int pspell_string_list_empty(const PspellStringList *);
  
  
#ifdef __cplusplus
}
#endif

#endif
