use strict;
use HTMLIO::Utils qw(uri_escape);

# here we declare our data.  we'll define it below.
use vars qw(%pf_box @elements @name_sorted_elements
	    @animals @common_sorted_animals
	    %categories);

@elements =
  ({ number=>'1', symbol=>'H', name=>'hydrogen' },
   { number=>'2', symbol=>'He', name=>'helium' },
   { number=>'3', symbol=>'Li', name=>'lithium' },
   { number=>'4', symbol=>'Be', name=>'beryllium' },
   { number=>'5', symbol=>'B', name=>'boron' },
   { number=>'6', symbol=>'C', name=>'carbon' },
   { number=>'7', symbol=>'N', name=>'nitrogen' },
   { number=>'8', symbol=>'O', name=>'oxygen' },
   { number=>'9', symbol=>'F', name=>'fluorine' },
   { number=>'10', symbol=>'Ne', name=>'neon' },
   { number=>'11', symbol=>'Na', name=>'sodium' },
   { number=>'12', symbol=>'Mg', name=>'magnesium' },
   { number=>'13', symbol=>'Al', name=>'aluminium' },
   { number=>'14', symbol=>'Si', name=>'silicon' },
   { number=>'15', symbol=>'P', name=>'phosphorus' },
   { number=>'16', symbol=>'S', name=>'sulfur' },
   { number=>'17', symbol=>'Cl', name=>'chlorine' },
   { number=>'18', symbol=>'Ar', name=>'argon' },
   { number=>'19', symbol=>'K', name=>'potassium' },
   { number=>'20', symbol=>'Ca', name=>'calcium' },
   { number=>'21', symbol=>'Sc', name=>'scandium' },
   { number=>'22', symbol=>'Ti', name=>'titanium' },
   { number=>'23', symbol=>'V', name=>'vanadium' },
   { number=>'24', symbol=>'Cr', name=>'chromium' },
   { number=>'25', symbol=>'Mn', name=>'manganese' },
   { number=>'26', symbol=>'Fe', name=>'iron' },
   { number=>'27', symbol=>'Co', name=>'cobalt' },
   { number=>'28', symbol=>'Ni', name=>'nickel' },
   { number=>'29', symbol=>'Cu', name=>'copper' },
   { number=>'30', symbol=>'Zn', name=>'zinc' },
   { number=>'31', symbol=>'Ga', name=>'gallium' },
   { number=>'32', symbol=>'Ge', name=>'germanium' },
   { number=>'33', symbol=>'As', name=>'arsenic' },
   { number=>'34', symbol=>'Se', name=>'selenium' },
   { number=>'35', symbol=>'Br', name=>'bromine' },
   { number=>'36', symbol=>'Kr', name=>'krypton' },
   { number=>'37', symbol=>'Rb', name=>'rubidium' },
   { number=>'38', symbol=>'Sr', name=>'strontium' },
   { number=>'39', symbol=>'Y', name=>'yttrium' },
   { number=>'40', symbol=>'Zr', name=>'zirconium' },
   { number=>'41', symbol=>'Nb', name=>'niobium' },
   { number=>'42', symbol=>'Mo', name=>'molybdenum' },
   { number=>'43', symbol=>'Tc', name=>'technetium' },
   { number=>'44', symbol=>'Ru', name=>'ruthenium' },
   { number=>'45', symbol=>'Rh', name=>'rhodium' },
   { number=>'46', symbol=>'Pd', name=>'palladium' },
   { number=>'47', symbol=>'Ag', name=>'silver' },
   { number=>'48', symbol=>'Cd', name=>'cadmium' },
   { number=>'49', symbol=>'In', name=>'indium' },
   { number=>'50', symbol=>'Sn', name=>'tin' },
   { number=>'51', symbol=>'Sb', name=>'antimony' },
   { number=>'52', symbol=>'Te', name=>'tellurium' },
   { number=>'53', symbol=>'I', name=>'iodine' },
   { number=>'54', symbol=>'Xe', name=>'xenon' },
   { number=>'55', symbol=>'Cs', name=>'caesium' },
   { number=>'56', symbol=>'Ba', name=>'barium' },
   { number=>'57', symbol=>'La', name=>'lanthanum' },
   { number=>'58', symbol=>'Ce', name=>'cerium' },
   { number=>'59', symbol=>'Pr', name=>'praseodymium' },
   { number=>'60', symbol=>'Nd', name=>'neodymium' },
   { number=>'61', symbol=>'Pm', name=>'promethium' },
   { number=>'62', symbol=>'Sm', name=>'samarium' },
   { number=>'63', symbol=>'Eu', name=>'europium' },
   { number=>'64', symbol=>'Gd', name=>'gadolinium' },
   { number=>'65', symbol=>'Tb', name=>'terbium' },
   { number=>'66', symbol=>'Dy', name=>'dysprosium' },
   { number=>'67', symbol=>'Ho', name=>'holmium' },
   { number=>'68', symbol=>'Er', name=>'erbium' },
   { number=>'69', symbol=>'Tm', name=>'thulium' },
   { number=>'70', symbol=>'Yb', name=>'ytterbium' },
   { number=>'71', symbol=>'Lu', name=>'lutetium' },
   { number=>'72', symbol=>'Hf', name=>'hafnium' },
   { number=>'73', symbol=>'Ta', name=>'tantalum' },
   { number=>'74', symbol=>'W', name=>'tungsten' },
   { number=>'75', symbol=>'Re', name=>'rhenium' },
   { number=>'76', symbol=>'Os', name=>'osmium' },
   { number=>'77', symbol=>'Ir', name=>'iridium' },
   { number=>'78', symbol=>'Pt', name=>'platinum' },
   { number=>'79', symbol=>'Au', name=>'gold' },
   { number=>'80', symbol=>'Hg', name=>'mercury' },
   { number=>'81', symbol=>'Tl', name=>'thallium' },
   { number=>'82', symbol=>'Pb', name=>'lead' },
   { number=>'83', symbol=>'Bi', name=>'bismuth' },
   { number=>'84', symbol=>'Po', name=>'polonium' },
   { number=>'85', symbol=>'At', name=>'astatine' },
   { number=>'86', symbol=>'Rn', name=>'radon' },
   { number=>'87', symbol=>'Fr', name=>'francium' },
   { number=>'88', symbol=>'Ra', name=>'radium' },
   { number=>'89', symbol=>'Ac', name=>'actinium' },
   { number=>'90', symbol=>'Th', name=>'thorium' },
   { number=>'91', symbol=>'Pa', name=>'protactinium' },
   { number=>'92', symbol=>'U', name=>'uranium' },
   { number=>'93', symbol=>'Np', name=>'neptunium' },
   { number=>'94', symbol=>'Pu', name=>'plutonium' },
   { number=>'95', symbol=>'Am', name=>'americium' },
   { number=>'96', symbol=>'Cm', name=>'curium' },
   { number=>'97', symbol=>'Bk', name=>'berkelium' },
   { number=>'98', symbol=>'Cf', name=>'californium' },
   { number=>'99', symbol=>'Es', name=>'einsteinium' },
   { number=>'100', symbol=>'Fm', name=>'fermium' },
   { number=>'101', symbol=>'Md', name=>'mendelevium' },
   { number=>'102', symbol=>'No', name=>'nobelium' },
   { number=>'103', symbol=>'Lr', name=>'lawrencium' },
   { number=>'104', symbol=>'Rf', name=>'rutherfordium' },
   { number=>'105', symbol=>'Db', name=>'dubnium' },
   { number=>'106', symbol=>'Sg', name=>'seaborgium' },
   { number=>'107', symbol=>'Bh', name=>'bohrium' },
   { number=>'108', symbol=>'Hs', name=>'hassium' },
   { number=>'109', symbol=>'Mt', name=>'meitnerium' },
   { number=>'110', symbol=>'Uun', name=>'ununnilium' },
   { number=>'111', symbol=>'Uuu', name=>'unununium' },
   { number=>'112', symbol=>'Uub', name=>'ununbium' },
   { number=>'114', symbol=>'Uuq', name=>'ununquadium' },
   { number=>'116', symbol=>'Uuh', name=>'ununhexium' },
   { number=>'118', symbol=>'Uuo', name=>'ununoctium' });

@name_sorted_elements =
  (map { $_->[0] }
   sort { $a->[1] cmp $b->[1] }
   map { [ $_, $_->{name} ] } @elements);

@animals =
  ({common => 'cougar', 
    species => 'Puma concolor', family => 'FELIDAE'},
   {common => 'panther', 
    species => 'Panthera pardus', family => 'FELIDAE'},
   {common => 'snowy owl', 
    species => 'Nyctea scandiaca', family => 'STRIGIDAE'},
   {common => 'tiger', 
    species => 'Panthera tigris', family => 'FELIDAE'},
   {common => 'lion', 
    species => 'Panthera leo', family => 'FELIDAE'},
   {common => 'grizzly bear', 
    species => 'Ursus arctos', family => 'URSIDAE'},
   {common => 'spotted hyena', 
    species => 'Crocuta crocuta', family => 'HYAENIDAE'},
   {common => 'great white shark', 
    species => 'Carcharodon carcharias', family => 'LAMNIDAE'},
   {common => 'black python', 
    species => 'Morelia boeleni', family => 'PYTHONIDAE'},
   {common => 'king cobra', 
    species => 'Ophiophagus hannah', family => 'ELAPIDAE'},
   {common => 'wolverine', 
    species => 'Gulo gulo', family => 'MUSTELIDAE'},
   {common => 'killer whale', 
    species => 'Orcinus orca', family => 'DELPHINIDAE'},
   {common => 'bobcat', 
    species => 'Lynx rufus', family => 'FELIDAE'},
   {common => 'lynx', 
    species => 'Lynx lynx', family => 'FELIDAE'},
   {common => 'cheetah', 
    species => 'Acinonyx jubatus', family => 'FELIDAE'},
   {common => 'atlantic coral snake', 
    species => 'Micrurus diastema', family => 'ELAPIDAE'},
   {common => 'panda', 
    species => 'Ailuropoda melanoleuca', family => 'URSIDAE'},
   {common => 'jaguar', 
    species => 'Panthera onca', family => 'FELIDAE'});

@common_sorted_animals =
  (map { $_->[0] }
   sort { $a->[1] cmp $b->[1] or $a->[2] cmp $b->[2] }
   map { [ $_, $_->{common}, $_->{species} ] } @animals);

%categories = (
	ach => 'ACH',
	atm => 'ATM',
	cam => 'Centralized Account Manager',
	cms => 'Capability Management System',
	db => 'Database interface software',
	dns => 'Domain Name Service',
	faps => 'Enrollment',
	fee => 'Fee Customer',
	fxapi => 'FXAPI',
	fxbase => 'Core issues',
	fxbp => 'Billpay',
	fxcim => 'Old FXCIM (both front and backend)',
	fxdb => 'FX database backend',
	fxdgs => 'FX Data Gathering System',
	fxim => 'FXIM/IMAPI backend issues',
	fximweb => 'FXIM frontend issues',
	fxrepo => 'Repurchase and Collateral systems',
	fxweb => 'FXAPI frontend (end customer stuff)',
	'gnats-adm' => 'Gnats Adm',
	'gnats-queue' => 'Gnats Queue',
	lending => 'Lending',
	lendingweb => 'Lending frontend',
	mic => 'Mesa Internet Compiler',
	misp => 'Mesa Internet Scheduling Program',
	'olbs-his' => 'OLBS-HIS (dead)',
	'olbs-import' => 'Strip import files',
	'olbs-sql' => 'Database SQL files',
	pending => 'Pending categorization',
	postgres => 'Postgres',
	releng => 'Release Engineering Issues',
	repo => 'Reports (dead)',
	reports => 'Reports',
	sbond => 'Savings Bonds',
	shopus => 'General ShopUS (dead)',
	'shopus-html' => 'ShopUS frontend (dead)',
	'shopus-search' => 'ShopUS search (dead)',
	support => 'Operations'
);

sub setup {
  %pf_box = ();
}

# this verification returns true if any of the input fields are not 
# blank, and false if all input fields are blank.
#
sub verify_not_all_blank {
  my ($fs,@field_names) = @_;

  for my $field_name (@field_names) {
    my $field = $fs->get_field($field_name) or throw 
	Error::Simple("'$field_name' is an invalid field name.");
    if ($field_name eq "family") {
      $field->value() !~ /^_/ and return 1;
    } else {
      $field->value() ne "" and return 1;
    }
  }

  return 0;
}

