#!/usr/bin/perl
use Config;

use lib qw(. ..);
use localutils;

my $vars = parse_makefile_vars();
my ($out_fname,$init) = parse_PL_argv(@ARGV);

$init->{PREFIX} ||= $vars->{PREFIX} || "/usr/local";
$init->{PILEDIR} ||= $init->{PREFIX}."/share/piles";
$init->{PILEDRIVER} ||= $init->{PREFIX}."/cgi/piledriver.cgi";

open_shell_script($out_fname);

print <<"END_OF_TOP";
[ -z "\$psp_conf" ] && psp_conf=$init->{PREFIX}/etc/psp.conf
[ -z "\$piledir" ] && piledir=$init->{PILEDIR}
[ -z "\$piledriver" ] && piledriver=$init->{PILEDRIVER}
END_OF_TOP

print <DATA>;

close_script();

__END__

# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: testpile.PL,v 1.5 2001/04/07 01:05:09 muaddie Exp $

if [ "$1" = "-verbose" ]; then
  shift
  do_verbose=1
fi

if [ "$1" = "-debug" ]; then
  shift
  do_debug=1
fi

if [ "$1" = "-query" ]; then
  shift
  query_string=$1
  shift
fi

if [ "$1" = "" ]; then
  echo Usage: $0 '<url relative to /piles/>'
  exit 1
fi
pileurl=$1

[ -z "$PATH_TRANSLATED" ] && PATH_TRANSLATED="$piledir/$pileurl"
[ -z "$REDIRECT_URL" ] && REDIRECT_URL="/piles/$pileurl"
[ -z "$PSP_CONF" ] && PSP_CONF=$psp_conf
export PATH_TRANSLATED REDIRECT_URL PSP_CONF

[ ! -z "$do_debug" ] && perl_args="$perl_args -d"

display_url=http://server:port$REDIRECT_URL
[ "$query_string" ] && display_url="$display_url?$query_string"
echo Simulating $display_url ...

[ "$do_verbose" != "" ] && echo perl $perl_args $piledriver
perl $perl_args $piledriver
