/****************************************************************************
** statusdlg.cpp - dialog for setting and reading status messages
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"statusdlg.h"

#include<qpushbutton.h>
#include<qlayout.h>
#include<qlabel.h>


StatusShowDlg::StatusShowDlg(UserListItem *i)
:QDialog(0,0,FALSE,WDestructiveClose)
{
        // build the dialog
        QVBoxLayout *vb = new QVBoxLayout(this, 8);
        MsgMle *te = new MsgMle(this);
        vb->addWidget(te);
        QHBoxLayout *hb = new QHBoxLayout(vb);
        QPushButton *pb = new QPushButton(tr("&Close"), this);
        pb->setMinimumWidth(80);
        hb->addStretch(1);
        hb->addWidget(pb);
        hb->addStretch(1);

        // set the rest up
        te->setReadOnly(TRUE);
        te->setTextFormat(RichText);
        te->setText(linkify(plain2rich(i->statusString)));
	connect(te, SIGNAL(linkClicked(const QString &)), SLOT(aOpenURL(const QString &)));
        connect(pb, SIGNAL(clicked()), SLOT(close()));
        pb->setFocus();

        QString nick;
        if(i->nick.isEmpty())
                nick = i->jid;
        else
                nick = i->nick;

        setCaption(QString(tr("Status for %1")).arg(nick));

        resize(400,240);
}

void StatusShowDlg::aOpenURL(const QString &url)
{
	openURL(url);
}


static int combomap[4] = { STATUS_ONLINE, STATUS_AWAY, STATUS_XA, STATUS_DND };

StatusSetDlg::StatusSetDlg(StatusInfo *x_info)
:QDialog(0,0,TRUE)
{
        info = x_info;

        // build the dialog
        QVBoxLayout *vb = new QVBoxLayout(this, 8);
	QHBoxLayout *hb1 = new QHBoxLayout(vb);

	QLabel *l;
	l = new QLabel(tr("Status:"), this);
	hb1->addWidget(l);
	cb_type = new QComboBox(this);
	int n;
	for(n = 0; n < 4; ++n)
		cb_type->insertItem(status2txt(combomap[n]));
	for(n = 0; n < 4; ++n) {
		if(info->type == combomap[n]) {
			cb_type->setCurrentItem(n);
			break;
		}
	}
	hb1->addWidget(cb_type,1);
	l = new QLabel(tr("Preset:"), this);
	hb1->addWidget(l);
	cb_preset = new QComboBox(this);
	cb_preset->insertItem(tr("<None>"));
	cb_preset->insertStringList(option.sp.varsToStringList());
	connect(cb_preset, SIGNAL(highlighted(int)), SLOT(chooseStatusPreset(int)));
	hb1->addWidget(cb_preset,1);

        te = new MsgMle(this);
        vb->addWidget(te);
        QHBoxLayout *hb = new QHBoxLayout(vb);
        QPushButton *pb1 = new QPushButton(tr("&Set"), this);
        QPushButton *pb2 = new QPushButton(tr("&Cancel"), this);
        pb1->setMinimumWidth(80);
        pb2->setMinimumWidth(80);
        hb->addWidget(pb1);
        hb->addStretch(1);
        hb->addWidget(pb2);

        // set the rest up
        te->setTextFormat(PlainText);
        te->setText(info->str);
        te->selectAll();
        connect(pb1, SIGNAL(clicked()), SLOT(doButton()));
        connect(pb2, SIGNAL(clicked()), SLOT(close()));
        te->setFocus();

        setCaption(CAP(tr("Set Status")));

        resize(400,240);
}

void StatusSetDlg::doButton()
{
	info->type = combomap[cb_type->currentItem()];
        info->str = te->text();
        accept();
}

void StatusSetDlg::chooseStatusPreset(int x)
{
	if(x < 1)
		return;

	te->setText(option.sp.get(cb_preset->text(x)));
}

/* static */ bool StatusSetDlg::getStatus(StatusInfo *x_info)
{
        StatusSetDlg *w = new StatusSetDlg(x_info);
        bool ok;

        ok = (w->exec() == Accepted) ? TRUE: FALSE;

        delete w;
        return ok;
}
