/****************************************************************************
** msgmle.h - subclass of QTextEdit to handle various hotkeys
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef MSGMLE_H
#define MSGMLE_H

#include<qtextedit.h>

class MsgMle : public QTextEdit
{
	Q_OBJECT
public:
	MsgMle(QWidget *parent=0, const char *name=0);

signals:
	void linkClicked(const QString &);

protected:
	// override the tab/esc behavior
	bool focusNextPrevChild(bool next);
	void keyPressEvent(QKeyEvent *);
	bool linksEnabled() const { return TRUE; }
	QPopupMenu *createPopupMenu(const QPoint& pos);

private slots:
	void menuURL();
	void menuCopy();

private:
	void emitLinkClicked(const QString &);

	QString lastLink;
};

class ChatMle : public QTextEdit
{
public:
	ChatMle(QWidget *parent=0, const char *name=0);

protected:
	// override the tab/esc behavior
	bool focusNextPrevChild(bool next);
	void keyPressEvent(QKeyEvent *);
};

#endif
