/****************************************************************************
** jabcon.h - core control class for Psi
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef JABCON_H
#define JABCON_H

#include<qstring.h>
#include<qobject.h>
#include<qpixmap.h>
#include<qsettings.h>
#include<qptrlist.h>
#include<qvaluelist.h>
#include<qwidcoll.h>

#include"jabcommon.h"
#include"jabber.h"
#include"mainwin.h"
#include"userlist.h"
#include"message.h"
#include"contactview.h"
#include"chatdlg.h"
#include"adduserdlg.h"
#include"idle.h"
#include"filetrans.h"
#include"profiles.h"
#include"jabsess.h"


struct EventItem
{
	QString jid;
	Message msg;
};

class EventQueue : public QPtrList<EventItem>
{
public:
	EventQueue();

	int count(const QString &);
	void enqueue(EventItem *);
	EventItem *dequeue(const QString &);
	EventItem *peek(const QString &);
	EventItem *dequeueNext();
	EventItem *peekNext();
	bool hasChats(const QString &);
	void extractChats(const QString &jid, QPtrList<Message> *list, QValueList<int> *pos);
	void removeAll(const QString &jid);
};


class jabcon : public QObject
{
	Q_OBJECT

public:
	jabcon(QObject *parent=0);
	~jabcon();

	bool init();

	UserProfile pro;
	JabSessionManager jsm;
	JabSession *s;

	MainWin *mainwin;
	ContactProfile *cvp;

	FileServer *fileserv;
	Idle idle;

	QRect mwgeom;
	QString lastStatusString;

	EventQueue events;

	void queueMessage(const Message &);
	void logMessage(const Message &);
	void queueUnread(UserListItem *);
	void flagAsRead(const Message &);

	void userRemove(UserListItem *);
	void userRename(UserListItem *, const QString &);
	void userGroupChange(UserListItem *, const QString &);

	void insertMessage(const Message &, bool doLog=TRUE);
	ChatDlg *ensureChatDlg(const QString &);

	void doOnEvent(const QString &);

signals:
	void quit(int);
	void emitContact(UserListItem *);
	void emitLocalUpdate(const JabRosterEntry &);
	void emitOptionsUpdate();
	void emitNewOffer(FileServerItem *);

public slots:
	// backend
	/*void servConnected();
	void servDisconnected();
	void statusUpdate(JabUpdate *);
	void servError(JabError *);

	// messages
	void messageReceived(const JabMessage &);

	// availability
	void resourceAvailable(const Jid &, const JabResource &);
	void resourceUnavailable(const Jid &);

	// roster management
	void contactChanged(JabRosterEntry *);
	void contactNew(JabRosterEntry *);
	void contactRemove(JabRosterEntry *);

	// subscription
	void authRequest(const Jid &);
	void authGrant(const Jid &);
	void authRemove(const Jid &);*/

	// multi-session
	void jab_connected(JabSession *);
	void jab_disconnected(JabSession *);
	void jab_statusUpdate(JabSession *, JabUpdate *);
	void jab_error(JabSession *, JabError *);
	void jab_messageReceived(JabSession *, const JabMessage &);
	void jab_resourceAvailable(JabSession *, const Jid &, const JabResource &);
	void jab_resourceUnavailable(JabSession *, const Jid &);
	void jab_contactChanged(JabSession *, JabRosterEntry *);
	void jab_contactNew(JabSession *, JabRosterEntry *);
	void jab_contactRemove(JabSession *, JabRosterEntry *);
	void jab_authRequest(JabSession *, const Jid &);
	void jab_authGrant(JabSession *, const Jid &);
	void jab_authRemove(JabSession *, const Jid &);


	// user related
	void userAdd(const QString &);
	void userAuthorize(const QString &);
	void userAddAuth(const QString &);

	// offer a file
	void offerFile(const QString &fname, const QString &desc, const QString &jid);


	// actions
	void actionDefault(ContactViewItem *);
	void actionRecvEvent(ContactViewItem *);
	void actionSendMessage(ContactViewItem *);
	void actionSendMessage(const QStringList &);
	void actionSendUrl(const QString &);
	void actionRemove(const QString &jid);
	void actionAuthorize(ContactViewItem *);
	void actionAdd(ContactViewItem *);
	void actionRename(ContactViewItem *, const QString &);
	void actionGroupChange(const QString &jid, const QString &);
	void actionGroupRename(const QString &, const QString &);
	void actionHistory(const QString &);
	void actionHistoryBox(const Message &);
	void actionStatusShow(const QString &);
	void actionOpenChat(const QString &jid);
	void actionInfo(const QString &);
	void actionAdd(const QString &jid, const QString &nick, const QString &group);
	void actionOfferFile(const QString &jid);
	void actionOpenURL(const QString &);

	void agentSetStatus(const QString &, int);
	void agentRemove(const QString &);

	void readMessage(UserListItem *);
	void openChat(UserListItem *);
	void composeMessage(UserListItem *, bool);

	void sendMessage(const Message &);

	void processReadNext(UserListItem *item);
	void processChats(UserListItem *item);

	void statusMenuChanged(int);
	//void askLogin();
	//void delayedAskLogin();
	void askAddUser();
	void slotAddUser(const AddUserDlg::Info &);
	void closeProgram();
	void changeProfile();
	void doOptions();
	void slotApplyOptions(const Options &);
	void slotApplyAccounts();
	void doManageServices();
	void doManageAccounts();
	void doFileSharing();
	void composeBlankMessage();
	void openAccountInfo();
	void recvNextEvent();

	void composeMessage(const QString &);
	void processReadNext(const QString &);
	void processChats(const QString &);

	void slotGetServices(QString *id);
	void slotGetServicesResponse(JabRoster *);

	void slotGetRegForm(const QString &service, QString *id);
	void slotGetRegFormResponse(const JabForm &);
	void slotPutRegForm(const JabForm &, QString *id);
	void slotPutRegFormResponse(const QString &, bool, const QString &err);

	void slotGetVCard(const QString &, QString *id);
	void slotGetVCardResponse(const QString &, VCard *);
	void slotSetVCard(const VCard &, QString *id);
	void slotSetVCardResponse(bool);

	void slotGetSearchForm(const QString &, QString *id);
	void slotGetSearchFormResponse(const QString &, JabForm *);
	void slotPutSearchForm(const JabForm &, QString *id);
	void slotPutSearchFormResponse(const QString &, JabRoster *);

	void slotGetIQGateway(const QString &, QString *id);
	void slotSetIQGateway(const QString &, const QString &, QString *id);

	void slotCancelTransaction(const QString &);

	void slotJTDone(JabTask *t);

	void slotCheckVCard(JabTask *);

	void enableOnEventOnline();
};

#endif
