/****************************************************************************
** historydlg.h - a dialog to show message history
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef HISTORYDLG_H
#define HISTORYDLG_H

#include<qwidget.h>
#include<qstring.h>
#include<qlistview.h>
#include<qsimplerichtext.h>
#include<qcombobox.h>
#include"common.h"
#include"userlist.h"
#include"message.h"
#include"uniquewindow.h"


class HistoryViewItem : public QListViewItem
{
public:
        HistoryViewItem(Message *, int id, QListView *);
        ~HistoryViewItem();

        QSimpleRichText *rt;

        Message *msg;
        QString text;
        int id;

        // reimplemented
        void paintCell(QPainter *p, const QColorGroup & cg, int column, int width, int alignment);
        void setup();
        int compare(QListViewItem *xi, int column, bool ascending) const;
};


class HistoryView : public QListView
{
        Q_OBJECT
public:
        HistoryView(QWidget *parent=0, const char *name=0);

        void doResize();
        void addMessage(Message *);

        // reimplemented
        void keyPressEvent(QKeyEvent *e);

signals:
        void aOpenMessage(const Message &);

private:
        void resizeEvent(QResizeEvent *e);
        int at_id;

private slots:
        void doOpenMessage();

        void qlv_doubleclick(QListViewItem *);
        void qlv_contextPopup(QListViewItem *, const QPoint &, int);
};


class HistoryDlg : public QWidget, public UniqueWindow
{
        Q_OBJECT
public:
        HistoryDlg(UserListItem *item, QWidget *parent=0, const char *name=0);

        QString & jid() { return v_jid; }

        static HistoryDlg * find(const QString &);

        // reimplemented
        void keyPressEvent(QKeyEvent *e);

signals:
        void openMessage(const Message &);

public slots:
        void refresh();

        // reimplemented
        void show();

private slots:
        void comboChanged(int);
        void searchTextChanged(const QString &);
        void doSearch();
        void doRefresh();

        void actionOpenMessage(const Message &);

private:
        QString v_jid;
        HistoryView *lv;
        QLineEdit *le_search;
        QPushButton *pb_go;
        QString searchStr;
        int amountToShow;
};

#endif
