/****************************************************************************
** common.h - contains all the common variables and functions for Psi
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef COMMON_H
#define COMMON_H

#include<qstring.h>
#include<qpixmap.h>
#include<qimage.h>
#include<qstringlist.h>
#include<qwidget.h>
#include<qmessagebox.h>
#include<qprocess.h>
#include"anim.h"
#include"logwindow.h"
#include"message.h"
#include"jabber.h"
#include"varlist.h"
#include"jabcommon.h"


#define DEBUG_JABXML    0
#define DEBUG_JABBER    1
#define DEBUG_JABCON    2
#define DEBUG_MAINWIN   3
#define DEBUG_CV        4
#define DEBUG_HIGH      5


// global
struct PsiGlobal
{
	QString pathBase, pathHome, pathProfiles;
};

extern QString activeProfile;


// options stuff
enum { cOnline, cOffline, cAway, cDND, cGroupFore, cGroupBack, cListBack };
enum { fRoster, fMessage, fChat };
enum { eMessage, eChat1, eChat2, eSystem, eOnline, eOffline, eSend };
enum { dcClose, dcHour, dcDay, dcNever };

struct Options
{
	QColor color[7];
	QString font[3];
	QString iconset;
	int alertStyle;

	bool useleft, singleclick, askOnline, popupMsgs, popupChats, raise;
	bool alwaysOnTop, noAwaySound, rosterAnim;
	bool useDock, dockDCstyle;
	int delChats, browser;

	int defaultAction;
	int outgoingAs, incomingAs;
	VarList sp;

	int asAway, asXa, asOffline;
	QString onevent[7];

	QString player;
	QString customBrowser, customMailer;

	bool ignoreHeadline, scrollTo, keepSizes;

	QSize sizeEventDlg, sizeChatDlg;
};


// functions

QString getResourcesDir();
QString getHomeDir();

QString getHistoryDir();

QString qstrlower(QString);
int qstrcasecmp(const QString &str1, const QString &str2);
int qstringlistmatch(QStringList &list, const QString &str);
QString qstringlistlookup(QStringList &list, int x);
QString CAP(const QString &str);

void pdb(int depth, const QString &);

QPixmap & status2pix(int status);
QImage & status2qim(int status);
QString status2txt(int status);

QString eatptag(QString txt);
QString plain2rich(const QString &);
QString clipStatus(const QString &str, int width, int height);
QString expandEntities(const QString &in);
QString resolveEntities(const QString &);
QString linkify(const QString &);
QString encodePassword(const QString &, const QString &);
QString decodePassword(const QString &, const QString &);

const QString & transport2str(const QString &name);
QPixmap & transport2icon(const QString &, int status=STATUS_ONLINE);

QPixmap *loadImage(const QString &fname, const QStringList &dirs);
char *loadImageData(const QString &fname, const QStringList &dirs, int *size);
Anim *loadAnim(const QString &sbase, const QString &sf1, const QString &sf2, const QString &sf3, const QString &sf4);

void bringToFront(QWidget *w);
#ifdef Q_WS_WIN
void win_raiseNoFocus(QWidget *w);
#endif
QString jidEncode(const QString &jid);
QString jidDecode(const QString &jid);

QString jidnick(const QString &jid, const QString &nick);

int hexChar2int(char c);
char int2hexChar(int x);

QString logencode(QString);
QString logdecode(const QString &);

void unfinishedSoftware();

bool loadPsiIconSet(const QString name);
void unloadPsiIconSet();
void getPsiIconSets(QStringList &names, QStringList &descriptions);

void openURL(const QString &);

Anim *messagetype2anim(int type);
QString messagetype2str(int type);

QString getOSName();
int getTZOffset();
QString getTZString();

bool fileCopy(const QString &src, const QString &dest);

#ifdef Q_WS_MAC
void stopDockTileBounce();
void bounceDockTile();
#endif


struct StatusInfo
{
        int type;
        QString str;
};


struct TransportIconSet
{
	QPixmap *p[5];
};

extern TransportIconSet tic[5];

extern
QString PROG_NAME, PROG_VERSION;

extern
QPixmap *pix_online,
	*pix_offline,
	*pix_away,
	*pix_xa,
	*pix_dnd,
	*pix_blank,
	*pix_arrow[3],
	*pix_add,
	*pix_remove,
	*pix_send,
	*pix_history,
	*pix_info,
	*pix_url,
	*pix_ssl_yes,
	*pix_ssl_no,
	*pix_logo,
	*pix_changeacc,
	*pix_main,
	*pix_bigIcon,
	*pix_chatsend1,
	*pix_chatsend2,
	*pix_chatclear,
	*pix_account,
	*pix_icon_48,
	*pix_ft_back,
	*pix_ft_file,
	*pix_ft_folder;

extern
QImage  *qim_online,
	*qim_offline,
	*qim_away,
	*qim_xa,
	*qim_dnd;

extern char *pixdat_ft_back, *pixdat_ft_file, *pixdat_ft_folder;
extern int pixlen_ft_back, pixlen_ft_file, pixlen_ft_folder;

extern
Anim *anim_message, *anim_system, *anim_chat, *anim_headline;

extern
LogWindow *debug_window;

extern
Jabber *debug_jabber;

extern
Options option;

extern
PsiGlobal g;

extern
bool useSound;

#endif
