/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  tftp.h
 * Purpose: Definitions for implementing the TFTP protocol
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * TFTP packet types:
 */
#define	TFTP_RRQ	1		/* read request			*/
#define	TFTP_WRQ	2		/* write request		*/
#define	TFTP_DATA	3		/* data packet			*/
#define	TFTP_ACK	4		/* acknowledgement		*/
#define	TFTP_ERROR	5		/* error code			*/



/*
 **************************************************************************
 *
 * Error codes:
 */
#define	EUNDEF		0		/* not defined			*/
#define	ENOTFOUND	1		/* file not found		*/
#define	EACCESS		2		/* access violation		*/
#define	ENOSPACE	3		/* disk full			*/
#define	EBADOP		4		/* illegal TFTP operation	*/
#define	EBADID		5		/* unknown transfer ID		*/
#define	EEXISTS		6		/* file already exists		*/
#define	ENOUSER		7		/* no such user			*/



/*
 **************************************************************************
 *
 * TFTP UDP port numbers:
 */
#define TFTP_S_PORT	69		/* TFTP server port		*/
#define TFTP_C_PORT	1024		/* TFTP client port		*/



/*
 **************************************************************************
 *
 * Various definitions:
 */
#define TFTP_RETRY	10		/* Maximum number of retries	*/
#define TFTP_TIMEOUT	8		/* 8 seconds timeout		*/
#define OCTET_STR	"octet"		/* define name of data format	*/



/*
 **************************************************************************
 *
 * TFTP packet:
 */
struct tftphdr
{
	unsigned short th_op;			/* TFTP op code		*/
	unsigned short th_block;		/* block number		*/
	unsigned char  th_data[SEGSIZE];	/* data block		*/
};

#define th_error th_block			/* error code		*/

