/***************************************************************************
                          prokyon.h  -  WARNING
                          --------------------
   DEFINE are devilish!!!
   See "The C++ Programming Language" Bjarne Stroustup Section 7.8 
   try to use const variables instead....
 
 ***************************************************************************/


#ifndef PROKYON_H
#define PROKYON_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define PROKYON_HOME (QString(PREFIX) + QString("/share/prokyon3"))

#ifdef EMBEDDED
#define EMBEDDED_STRING " embedded"
#else
#define EMBEDDED_STRING ""
#endif   // ifdef EMBEDDED

#if HAVE_ID3
#define LIBRARY_ID3_STRING " id3lib"
#else
#define LIBRARY_ID3_STRING ""
#endif /* HAVE_ID3 */
#if HAVE_OGG
#define LIBRARY_OGG_STRING " libvorbis/ogg"
#else
#define LIBRARY_OGG_STRING ""
#endif /* HAVE_OGG */
#if HAVE_FLAC
#define LIBRARY_FLAC_STRING " libflac/flac++"
#else
#define LIBRARY_FLAC_STRING ""
#endif /* HAVE_FLAC */
#if HAVE_TAG
#define LIBRARY_TAG_STRING " taglib"
#else
#define LIBRARY_TAG_STRING ""
#endif /* HAVE_TAG */

#include <libintl.h>

#ifndef QT_THREAD_SUPPORT
#define QT_THREAD_SUPPORT
#endif
#include <qthread.h>

#include <qapplication.h>
#include <qdatetime.h>
#include <qlistview.h>
#include <qpixmap.h>
#include <qlibrary.h>
#include <qdialog.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <stdlib.h>
#include <qpushbutton.h>

#define MIMETYPE_MP3 1
#define MIMETYPE_OGG 2
#define MIMETYPE_FLAC 3

#define FSTAB     "/etc/fstab"
#define MTAB      "/etc/mtab"

const int QUERY_BY_ARTIST        = 1;
const int QUERY_BY_MEDIUM        = 2;
const int QUERY_BY_PHRASE        = 3;
const int QUERY_BY_WHERE         = 4;
const int QUERY_BY_PLAYLIST      = 5;
const int QUERY_BY_ARTIST_ALBUM  = 6;
const int QUERY_BY_ALBUM         = 7;
const int XMMS_PLAY              = 8;
const int XMMS_ENQUEUE           = 9;
const int MEXTRAS_ZAP            = 10;
const int MEXTRAS_GET            = 11;
const int MEXTRAS_QUERY_MEDIUM   = 12;
const int CH1_ENQUEUE            = 13;
const int CH2_ENQUEUE            = 14;

// specific prokyon3  event code

const int LOGEVENT_CODE                    = QEvent::User+1;
const int ALLMUSICEXTRASJOBSDONEEVENT_CODE = QEvent::User+2;
const int EXTRAEVENT_CODE                  = QEvent::User+3;
const int STATUSEVENT_CODE                 = QEvent::User+4;
const int MESSAGEEVENT_CODE                = QEvent::User+5;
const int PLAYLISTIMPORTEVENT_CODE         = QEvent::User+6;
const int NEWMUSICEXTRASJOBEVENT_CODE      = QEvent::User+7;
const int MUSICEXTRASJOBDONEEVENT_CODE     = QEvent::User+8;
const int NEWCOVERIMAGEEVENT_CODE          = QEvent::User+9;
const int NEWCOVERIMAGESEVENT_CODE         = QEvent::User+10;

const int PLAYER_REGULAR   = 1;
const int PLAYER_PRELISTEN = 2;

//*********  Do not forget to also modify JOB_CODE[] in prokyon.cpp if you need new  JOB codes below...

#define JOB_CONNECT_TO_DATABASE         1
#define JOB_DISCONNECT_FROM_DATABASE    2
#define JOB_MODIFY_FAVOURITE            3
#define JOB_SYNCHRONIZE_WITH_DATABASE   4
#define JOB_QUERY_DATABASE              5
#define JOB_MODIFY_TRACKS_IN_DATABASE   6
#define JOB_COMPUTE_CDROM_ID            7
#define JOB_APPEND_CDROM_TO_DATABASE    8
#define JOB_DELETE_MEDIUM_FROM_DATABASE 9
#define JOB_APPEND_SMB_TO_DATABASE      10
#define JOB_DELETE_TRACK_PHYSICALLY     11
#define JOB_APPEND_NFS_TO_DATABASE      12
#define JOB_MODIFY_PLAYLISTS            13
#define JOB_MODIFY_PLAYLIST_TRACKS      14
#define JOB_QUERY_PLAYLIST_TRACKS       15
#define JOB_COUNT_DATA                  16
#define JOB_GENERATE_PLAYLIST           17
#define JOB_GET_EXTRA_DATA              18
#define JOB_CALL_MUSICEXTRAS            19
#define JOB_PLAYALBUM                   20
#define JOB_CONNECT_TO_MIXXX            21
#define JOB_DISCONNECT_FROM_MIXXX       22
#define JOB_IMPORT_PLAYLIST             23
#define JOB_RENAME_MEDIUM               24
#define JOB_STORE_CUSTOM_QUERY          25
#define JOB_REMOVE_CUSTOM_QUERY         26

extern const char* JOB_CODE[27]; // debug only.

#define MEDIUM_HARDDISK 0
#define MEDIUM_CDROM    1
#define MEDIUM_SMB      2
#define MEDIUM_EXTERN   3
#define MEDIUM_NFS      4

// Various tag for comment field

#define NORMAL     "Normal"
#define SAMPLER    "Sampler"
#define SOUNDTRACK "Soundtrack"
#define MUSICAL    "Musical"
#define COMEDY     "Comedy"
#define DRAMA      "Radio Drama"
#define TESTMUSICEXTRAS "<Test_musicextras>"

#define PIXEL_SHIFT 2   // inverted textshift for text displayed on background pixmap.

/************************************
A commodity class 
 
It reads locale encoded string returned by  gettext() 
and returns a QString or a const char* depending on context.
 
This is an alternative to 
#define _(String) gettext (String)
QTextCodec::setCodecForCStrings (  QTextCodec::codecForLocale() );
************************************/

class _ : public QString {
public:
    _( const char * String )
:QString( QString::fromLocal8Bit( gettext(String) ) ) {}
    operator const char *() const {
        qstrncpy( ss, local8Bit().data(), 255 );
        return ss;
    }
    static char ss[255];
};


class View_Dialog : public QDialog {
    Q_OBJECT
public:
    View_Dialog(QWidget *parent,  const QString &s, const Qt::TextFormat type= Qt::RichText,
            const char *name=0): QDialog(parent, name) {
        text = new QTextEdit(this);
        QVBoxLayout *vb=new QVBoxLayout(this);
        vb->addWidget( text );
        quit = new QPushButton( "&Quit", this);
        vb->addWidget( quit );
        resize( QSize(400,300) );
        //    text->setWordWrap(QTextEdit::WidgetWidth);
        text->setTextFormat( type );
        text->setText(s);
        connect(quit, SIGNAL(clicked()), this, SLOT(close()));
    }
    ~View_Dialog() {
        ;
    }
private:
    QTextEdit* text;
    QPushButton* quit;
};


class ALBUMINFO {
public:
    ALBUMINFO(int a =0, int b=0, QString n =NULL) {
        total = a;
        local = b;
        name = n;
    }
    int local, total;
    QString name;
};

class DELTAINFO {
public:
    DELTAINFO(int a, int b, QString c ) {
        total = a;
        local = b;
        name = c;
        deltaalbum = new QMap<QString, ALBUMINFO>;
    }
    int total, local;
    QString name;
    QMap<QString, ALBUMINFO> *deltaalbum;
    ~DELTAINFO() {
        delete deltaalbum;
    }
};

struct ARTIST {
    int     id;
    QString name;
    int     total;
    int     local;
    bool    isFavourite;
};

struct ARTISTALBUM {
    QString artist;
    QString album;
    int     total;
    int     local;
    bool    isFavourite;
    int     artistId;
    int     medium;
};

struct TRACK {
    int       id;
    QString   path;
    QString   filename;
    int       medium;
    QDateTime lastModified;
    bool      hasChanged;
    bool      isRequested;
    QDateTime lastUpdated;
    int       mimetype;
    int       version;
    int       layer;
    int       mode;
    int       bitrate;
    int       samplerate;
    int       length;
    int       size;
    QString   artist;
    QString   title;
    QString   album;
    int       tracknumber;
    QString   year;
    int       genre;
    QString   comment;
    QString   notes;
    int       rating;
};

struct MEDIUM {
    int     id;
    int     type;
    QString label;
    QString path;
    uint     checksum;
};

struct PLAYLIST {
    int     id;
    QString name;
};

struct PLAYLIST_TRACK {
    int id;
    int track_id;
    int medium_id;
    int playlist_id;
    int position_in_playlist;
    QString artist;
    QString title;
    QString path;
    QString filename;
    int length;
    int size;
};

#ifdef HAVE_MEXTRAS
struct QIDPixmap {
    QPixmap image;
    long ID;
    QIDPixmap( long _ID, QPixmap _image ):image( _image ),ID( _ID ) {}
    QIDPixmap():image( QPixmap()),ID(0) {}
}
;

struct EXTRADATA {
    QByteArray artist_image;
    QByteArray cover_image;
    QString lyrics;
    QString synced_lyrics;
    QString years_active;
    QString album_review;
    QString album_tracks;
    QString biography;
};

struct EXTRADATA_GUI {
    QIDPixmap *artist_pixmap;
    QIDPixmap *cover_pixmap;
    QString lyrics;
    QString synced_lyrics;
    QString years_active;
    QString album_review;
    QString album_tracks;
    QString biography;
EXTRADATA_GUI():artist_pixmap(0),cover_pixmap(0),lyrics(0),years_active(0),album_review(0),biography(0) {}
}
;

struct EXTRA_STATUS {
    bool cover;
    bool lyrics;
    bool synced_lyrics;
    bool artist;
    bool years_active;
    bool album_review;
    bool album_tracks;
    bool biography;
    EXTRA_STATUS(bool _cover = false, bool _lyrics = false, bool _artist = false, bool _years_active = false, bool _album_review = false, bool _album_tracks = false, bool _biography = false)
:cover(_cover),lyrics(_lyrics),artist(_artist),years_active(_years_active),album_review(_album_review),album_tracks(_album_tracks),biography(_biography) {}
}
;
#endif /* HAVE_MEXTRAS */

struct STATUSDATA {
    QString message;
    int pos;
STATUSDATA( QString m,int p):message(m),pos(p) {}
}
;

class LogEvent : public QCustomEvent {
public:
    LogEvent( QString message )
: QCustomEvent( LOGEVENT_CODE ), msg( message ) {}
    QString message() const {
        return msg;
    }
private:
    QString msg;
};

class AllMusicExtrasJobsDoneEvent : public QCustomEvent {
public:
    AllMusicExtrasJobsDoneEvent()
: QCustomEvent( ALLMUSICEXTRASJOBSDONEEVENT_CODE ) {}
}
;

class MessageEvent : public QCustomEvent {
public:
    MessageEvent( QString message )
: QCustomEvent( MESSAGEEVENT_CODE ), msg( message ) {}
    QString message() const {
        return msg;
    }
private:
    QString msg;
};

class StatusEvent : public QCustomEvent {
public:
    StatusEvent( STATUSDATA *data )
: QCustomEvent( STATUSEVENT_CODE ), statusdata( data ) {}
    STATUSDATA *data() const {
        return statusdata;
    }
private:
    STATUSDATA *statusdata;
};

#ifdef HAVE_MEXTRAS
class ExtraEvent : public QCustomEvent {
public:
    ExtraEvent( EXTRADATA_GUI* data)
: QCustomEvent( EXTRAEVENT_CODE ), extradata( data ) {}
    EXTRADATA_GUI *data() const {
        return extradata;
    }
private:
    EXTRADATA_GUI *extradata;
};
#endif /* HAVE_MEXTRAS */

class PlaylistImportEvent : public QCustomEvent {
public:
    PlaylistImportEvent( QString _result, QStringList _notFound, QStringList _notSynced)
: QCustomEvent( PLAYLISTIMPORTEVENT_CODE ), res(_result), notF(_notFound), notS(_notSynced) {}
    QString result() const {
        return res;
    }
    QStringList notFound() const {
        return notF;
    }
    QStringList notSynced() const {
        return notS;
    }
private:
    QString res;
    QStringList notF;
    QStringList notS;
};

class NewMusicExtrasJobEvent : public QCustomEvent {
public:
    NewMusicExtrasJobEvent()
: QCustomEvent( NEWMUSICEXTRASJOBEVENT_CODE ) {}
}
;

class MusicExtrasJobDoneEvent : public QCustomEvent {
public:
    MusicExtrasJobDoneEvent()
: QCustomEvent( MUSICEXTRASJOBDONEEVENT_CODE ) {}
}
;

class NewCoverImageEvent : public QCustomEvent {
public:
    NewCoverImageEvent(QString _artist, QString _album)
: QCustomEvent( NEWCOVERIMAGEEVENT_CODE ), artist(_artist), album(_album) {}
    QString getArtist() const {
        return artist;
    }
    QString getAlbum() const {
        return album;
    }
private:
    QString artist;
    QString album;
};

class NewCoverImagesEvent : public QCustomEvent {
public:
    NewCoverImagesEvent()
: QCustomEvent( NEWCOVERIMAGESEVENT_CODE ) {}
}
;

class GUI;
class JobManager;
class DataBase;
class Configuration;
class DataDispatcher;
class MtabWatcher;
class SupermountWatcher;
class SubmountWatcher;
class PixmapCache;
#ifdef HAVE_MIXXX
class MixxxClient;
#endif /* HAVE_MIXXX */

extern GUI *gui;
extern JobManager *jobman;
extern DataBase *database;
extern Configuration *config;
extern DataDispatcher *datadispatcher;
extern MtabWatcher *mtabwatcher;
extern SupermountWatcher *supermountwatcher;
extern SubmountWatcher *submountwatcher;
extern PixmapCache *pixmapcache;
#ifdef HAVE_MIXXX
extern MixxxClient *mixxxClient;
#endif /* HAVE_MIXXX */
#if HAVE_LIBMUSICBRAINZ
class MusicBrainzClient;
extern MusicBrainzClient *musicBrainzClient;
#endif /*HAVE_LIBMUSICBRAINZ*/

extern QApplication *app;
extern int verbose;

void dumpdeltamap( QMap<int, QMap<int, DELTAINFO*> >* );
void dumpSelectedItems( QList<QListViewItem>*);
void dumpListTracks( QList<TRACK>* );
void dumpBaseList( QMap<int, int> * );
void dumpArtistToID( QMap<QString, int> * );
QString dumpAllQString(QString ss);
QString adjustQString(QString s);
QCString adjustString(QString s);
QString adjustStringCommandLine(QString s);
QString toLocaleString( QVariant qv);
void commandLineCallToRegularPlayer(QString, int);
void commandLineCallToRegularPlayer(QStringList, QString, int);

#ifdef HAVE_MEXTRAS
bool biography_isEmpty(QString bio);
bool years_active_isEmpty(QString years);
bool lyrics_isEmpty(QString lyrics);
bool synced_lyrics_isEmpty(QString lyrics);
bool album_review_isEmpty(QString album);
bool album_tracks_isEmpty(QString tracks);
#endif /* HAVE_MEXTRAS */

PLAYLIST_TRACK* getPlaylistTrackFromTrack(TRACK*);
void dumpQPixmap( QPixmap px );
void pauseWatchers();
void proceedWatchers();
QString albumTypeTranslation(QString type);
QString revertAlbumTypeTranslation(QString type);
bool isNormalAlbum(QString type);

#endif
