#include "qsql_2.3.h"
#include <exception>
#include <stdexcept>
#include <string>
#include <iostream>

#include <qmap.h>
#include <qdatetime.h>
#include <assert.h>
#include <qmessagebox.h>
#include <qstring.h>
#include <qapplication.h>



#undef EX_ON      // default. All sql++ Exceptions are caught below.      
//#define EX_ON   // sql++ are thrown


#define MAX_VARCHAR 255+1   

/*********************************************************
various non standard exceptions thrown by mysql++

//: Exception thrown when not enough parameters are provided
// Thrown when not enough parameters are provided for a 
// template query.
struct SQLQueryNEParms {
  SQLQueryNEParms(const char *c) : error(c) {}
  const char* error; //:
};

//: Exception thrown when a BadQuery is encountered
struct BadQuery {
  BadQuery(string er) : error(er) {}
  string error; //: The error message
};

//: Exception structure thrown when a bad conversion takes place
struct BadConversion {
  const char*  type_name;  //:
  const string data;       //:
  size_t       retrieved;  //:
  size_t       actual_size;//:
  BadConversion(const char* tn, const char* d, size_t r, size_t a) : type_name(tn), data(d), retrieved(r), actual_size(a) {};
};

//: Thrown when a *Null* value is trying to be converted into a type 
//: it can't convert to.
class BadNullConversion {};
*********************************************************/

using namespace qt_embedded_library;;

Connection *::QSqlDatabase::mycon = NULL;
QMap<QString,QSqlDatabase*> QSqlDatabase::databasemap; 

QSqlDatabase::QSqlDatabase( ) 
{
  con= NULL;
  IsOpen = false;
}

//  QSqlDatabase::~QSqlDatabase( ) 
//  {
//    qWarning( "QSqlDatabase dtor...");
//  }

QSqlDatabase* QSqlDatabase::addDatabase( const QString& type, const QString& connectionName) 
{
  if (type == "QMYSQL3" ) {
    QSqlDatabase *p = new QSqlDatabase();
    databasemap[ connectionName ] = p;
    return p;
  } else { 
#ifdef EX_ON
    throw out_of_range( "Only QMYSQL3 driver is supported" );
#else
    assert( 0 && "Only QMYSQL3 driver is supported");
#endif
    return NULL;
  }
} 

void QSqlDatabase::removeDatabase( const QString& connectionName )
{
  if ( databasemap.contains( connectionName ) ) {
    delete databasemap[ connectionName ];
    databasemap.remove( connectionName ); 
  } else {
#ifdef EX_ON
    throw out_of_range( QString("No connection with name %1..").arg( connectionName ).local8Bit().data() );
#else
    qWarning( QString("No connection with name %1..").arg( connectionName ).local8Bit().data() );
    assert( 0 );
#endif
  }
}

bool QSqlDatabase::contains( const QString& connectionName ) 
{
  return databasemap.contains( connectionName );
}

QSqlDatabase* QSqlDatabase::database( const QString& connectionName , bool open )
{
  if ( databasemap.contains( connectionName )) {
    QSqlDatabase *qs = databasemap[ connectionName ];
    if ( open && !qs->IsOpen ) { 
      qs->open();
    }
    return qs;
  } else {
    return NULL;  
  }
}

bool QSqlDatabase::open()
{
#ifndef EX_ON
  try {
#endif
    mycon = new Connection ( DatabaseName.ascii(), HostName.ascii(), UserName.ascii() , Password.ascii(), use_exceptions ) ;
    con = mycon;
#ifndef EX_ON
  } catch (BadQuery &er) {
    qWarning( "Qsql_2.3.cpp error : %s", er.error.c_str() );
    qApp->lock();
    QMessageBox::information( NULL, "Prokyon3",
			      QString("Could not connect to database.\n") + er.error.c_str(),QMessageBox::Ok);
    qApp->unlock();
    return false;
    IsOpen=false;
  } catch (std::exception &er) {
    qWarning(  "exception: %s", er.what() );
    return false;
    IsOpen=false;
  };
#endif
  IsOpen = true;
  return true;
}

void QSqlDatabase::close()
{
  if ( mycon ) delete mycon;
  mycon = NULL;
  IsOpen = false;
}

QString QSqlQuery::parse_first( QString sin, QChar sep) 
{
  QString temp = sin.stripWhiteSpace();
  return temp.left(temp.find( sep ));
}

QSqlQuery::~QSqlQuery() {
  if ( query ) delete query;
}

void QSqlQuery::CreateNewQuery( const QString& myquery, QSqlDatabase *db )
{
#ifndef EX_ON
  try {
#endif
    if ( !db ) { 
      if ( !QSqlDatabase::mycon )
#ifdef EX_ON
	throw out_of_range( "Trying to query with no default connection..." );
#else
      assert( 0 && "Trying to query with no default connection...");
#endif
      query = new Query( QSqlDatabase::mycon->query() ); }
    else
      query = new Query( db->con->query() );

    *query << string(myquery.data(),myquery.length());
    lastquery = myquery;
    res = query->store();
    it = res.begin();
    first = true;
    valid = true;
    active=true;
#ifndef EX_ON
  } catch (BadQuery &er) { // handle any connection error 
    qWarning( "SqlQuery - BadQuery error: %s", er.error.c_str() );
    valid = false;
    active=false;
    serror = QSqlError( QString::null, er.error.c_str(), QSqlError::Statement);
  } catch (std::exception &er) {
    qWarning(  "exception: %s", er.what() );
    valid = false;
    active = false;
    serror = QSqlError( QString::null, er.what(), QSqlError::Unknown);
  } catch (...) {
    assert( 0 && "unhandeld exception ????...");  // should never happen..... 
  }
#endif
}

QSqlQuery::QSqlQuery( const QString& myquery, QSqlDatabase* db )
{
  serror = QSqlError();
  CreateNewQuery( myquery, db );
}

bool QSqlQuery::next( )
{
  if ( !valid )
    return false;

  if (first) {
    first = false;
  } else it++;
  if (it != res.end() )
    return true;
  return false;
}

QVariant QSqlQuery::value( int i )
{
  if ( i < 0 || i >= res.names().size() ) {
#ifdef EX_ON
    throw out_of_range( "Wrong index in QSqlQuery::value()" );
#else
    assert( 0 && "Wrong index in QSqlQuery::value()");
#endif
    return QVariant();  // invalid Qvariant
  }

  if (!valid)
    return QVariant();  // invalid Qvariant

  row = *it;
  QString ss( parse_first( res.types(i).sql_name() , QChar(' ') ) );

  /* Be aware:
     mysql++ will return a valid cstring "NULL" but report 0 field length
     for NULL values in database.
  */    

  char tempstr[MAX_VARCHAR];
  int tempint;
  QByteArray qb;
  long unsigned int *jj = res.fetch_lengths();

  if ( ss == "INT" ) { 
    if ( jj[i] == 0 && strcmp( row[i], "NULL") == 0 ) 
      return QVariant();
    else {
      tempint = row[i];
      return QVariant( tempint); 
    }

  } else if ( ss == "VARCHAR" ) {
    if ( jj[i] == 0 && strcmp( row[i], "NULL") == 0 ) 
      return QVariant( QString::null ); 
    else 
      return QVariant( strcpy( tempstr, row[i] ) );

  } else if ( ss == "CHAR" ) {
    if ( jj[i] == 0 && strcmp( row[i], "NULL") == 0 ) 
      return QVariant();
    else 
      return QVariant( strcpy( tempstr, row[i] ) ); 

  } else if ( ss == "DATETIME" ) {
    if ( jj[i] == 0 && strcmp( row[i], "NULL") == 0 ) 
      return QVariant();
    else 
      return QVariant( QDateTime::fromString( strcpy( tempstr, row[i] ), Qt::ISODate )); 

  } else if ( ss == "TINYINT" ) {
    if ( jj[i] == 0 && strcmp( row[i], "NULL") == 0 ) 
      return QVariant();
    else {
      tempint = row[i];
      return QVariant( tempint); 
    }

  } else if ( ss == "BIGINT" ) {
    if ( jj[i] == 0 && strcmp( row[i], "NULL") == 0 ) 
      return QVariant();
    else {
      tempint = row[i];
      return QVariant( tempint); 
    }

  } else if ( ss == "BLOB" ) {
    if ( jj[i] == 0 && strcmp( row[i], "NULL") == 0 ) 
      return QVariant();
    else {
      qb.duplicate ( row.raw_data(i), jj[i] ) ;
      return QVariant( qb); 
    }
  } else { 
#ifdef EX_ON
    throw out_of_range( (QString("No conversion from ") + ss).local8Bit().data() );
#else
    qWarning( "No conversion from %s", ss.local8Bit().data() );
    assert( 0 );  // Type support not yet implemented for embedded MySQL server
#endif
  }

  return QVariant();  // invalid Qvariant
}

bool QSqlQuery::exec( const QString& aquery ) 
{
  if (query) delete query;
  CreateNewQuery( aquery );
  if ( valid )
    return true;
  else 
    return false;
} 

int QSqlQuery::size() const 
{
  if ( !valid ) 
    return -1;
  else
    //    return  res.names().size();   
   return  res.num_rows();   
}
