/***************************************************************************
                           job_storecustomquery.cpp
                             -------------------
    begin                : 2005-04-19
    copyright            : (C) 2005 by Markus Kalkbrenner
    email                : mkalkbrenner@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the license, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_storecustomquery.h"

#include "jobmanager.h"
#include "database.h"

#ifdef EMBEDDED 
  #include <mysql.h>
#endif

Job_StoreCustomQuery::Job_StoreCustomQuery(QString _name, QString _query)
  : name(_name), query(_query)
{}

void Job_StoreCustomQuery::run()
{
  int error = 0;

  if (verbose==8) qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

#ifdef EMBEDDED 
  mysql_thread_init(); 
#endif

  database->lock();
  database->storeCustomQuery(name, query);
  database->unlock();
  
  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();

#ifdef EMBEDDED 
  mysql_thread_end(); 
#endif

  if (verbose==8) qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

  exit();
}

Job_StoreCustomQuery::~Job_StoreCustomQuery() {}
