#include <qdatetime.h>

#include "job_generateplaylist.h"

#include "jobmanager.h"
#include "database.h"
#include "datadispatcher.h"

#ifdef EMBEDDED 
  #include <mysql.h>
#endif

Job_GeneratePlaylist::Job_GeneratePlaylist(int _numberTracks, int _minTrackLength, int _maxTrackLength, bool _onlyFavouriteArtists, bool _onlyHarddisk, int _minRating)
  : numberTracks(_numberTracks), minTrackLength(_minTrackLength), maxTrackLength(_maxTrackLength), onlyFavouriteArtists(_onlyFavouriteArtists), onlyHarddisk(_onlyHarddisk), minRating(_minRating)
{}

void Job_GeneratePlaylist::run()
{
  int error;
  int ID;

  if (verbose==8) qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

  QString time = QDateTime::currentDateTime().toString(Qt::ISODate);
  QString listname = QString(QString(_("generated")) + " " + time);
  
#ifdef EMBEDDED 
  mysql_thread_init(); 
#endif
  database->lock();
  ID = database->appendPlaylist(listname);
  error = database->getError();
  if(!error) {
      database->generatePlaylist(ID, numberTracks, minTrackLength, maxTrackLength, onlyFavouriteArtists, onlyHarddisk, minRating);

      if(!error) {
        PLAYLIST *playlist = new PLAYLIST();
        playlist->id = ID;
        playlist->name = listname;
        app->lock();
        datadispatcher->eventNewPlaylist(playlist, true);
        app->unlock();
      }
  }
  database->unlock();

  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
#ifdef EMBEDDED 
  mysql_thread_end(); 
#endif

  if (verbose==8) qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

  exit();
}

Job_GeneratePlaylist::~Job_GeneratePlaylist() {}
