/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: urlnode.cc,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:21  slash
 * Initial release.
 *
 */

#include "main.h"
#include "contentnode.h"
#include "urlnode.h"


//---------------------------------------------------------------------------
URLNode::URLNode(xmlNodePtr node) : Node()
{
    cout << "Warning : The <url> markup is obsolete. Please adapt your" << endl
         << "          presentation to make use of the <a> markup." << endl;

    // Extract the properties of the url-tag.
    url_  = (char*)xmlGetProp(node, (xmlChar*)"url");
    name_ = (char*)xmlGetProp(node, (xmlChar*)"name");
}

//---------------------------------------------------------------------------
URLNode::~URLNode()
{
}


//---------------------------------------------------------------------------
void URLNode::writeHTML(int parameter) const
{
    Output_ << "<A href=\"" << url_ << "\">"
            << (name_ ? name_ : url_)
            << "</A>";
}

//---------------------------------------------------------------------------
void URLNode::writeLaTeX() const
{
    Output_ << "\\url{" << url_ << "}";
}

//---------------------------------------------------------------------------
void URLNode::writeXML() const
{
    Output_ << "<url"
            << " url=\"" << url_ << "\"";
    if (name_) {
        Output_ << " name=\"" << name_ << "\"";
    }
    Output_ << ">";
}
