/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: imgnode.cc,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:23  slash
 * Initial release.
 *
 */

#include "main.h"
#include "imgnode.h"

//---------------------------------------------------------------------------
ImgNode::ImgNode(xmlNodePtr node,
                 int latex_scale) : Node()
{
    size_.height_ = 0;
    size_.width_ = 0;
    latex_scale_ = latex_scale;

    // Extract the filenames of the image.
    filename_html_  = (char*)xmlGetProp(node, (xmlChar*)"html");
    filename_latex_ = (char*)xmlGetProp(node, (xmlChar*)"latex");

    if (filename_html_) {
        ping_image(filename_html_, &size_);
    }
}

//---------------------------------------------------------------------------
ImgNode::~ImgNode()
{
}


//---------------------------------------------------------------------------
void ImgNode::writeHTML(int parameter) const
{
    Output_ << "<IMG"
            << " src=\"" << filename_html_ << "\""
            << " alt=\"\"";
    if ((size_.height_ != 0) && (size_.width_ != 0)) {
        Output_ << " height=\"" << size_.height_ << "\""
                << " width=\"" << size_.width_ << "\"";
    }
    Output_ << ">" << endl;
}

//---------------------------------------------------------------------------
void ImgNode::writeLaTeX() const
{
    if (filename_latex_) {
        Output_ << "\\includegraphics";
        if (latex_scale_) {
            Output_ << "[width=\\linewidth]";
        }
        Output_ << "{" << filename_latex_ << "}" << endl;
    }
}

//---------------------------------------------------------------------------
void ImgNode::writeXML() const
{
    Output_ << "<img"
            << " html=\"" << filename_html_ << "\""
            << " latex=\"" << filename_latex_ << "\"";
    Output_ << "/>" << endl;
}
