/*****
*
* Copyright (C) 2001, 2002 Jeremie Brebec <flagg@ifrance.com>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
* Written by Jeremie Brebec <flagg@ifrance.com>
* Written by Yoann Vandoorselaere <yoann@prelude-ids.org>
*
*****/

typedef struct {
        idmef_classification_origin_t origin;
        char *url;
        int url_len;
} data_reference_t;


typedef struct {
	char *msg;
	int len;
} data_msg_t;


typedef struct {
        char *shortname;
        char *desc;
        int desclen;

        idmef_impact_type_t type;
        idmef_impact_severity_t severity;
        idmef_impact_completion_t completion;
                
        struct list_head list;
} classtype_t;


void init_key_parser(void);

int add_reference(const char *name, const char *url);

int add_classtype(const char *shortname, const char *desc, const char *priority,
                  const char *type, const char *completion);

