//******************************************************************************
// Copyright (C) 1998-2000 TLK Games all rights reserved.
// programmer : Bruno Ethvignot    bruno@tlk.fr
// use Synthetic Audio Library Software Development Kit / Copyright 1995, 1996 Carlos Hasan. All Rights Reserved / http://www.egerter.com/seal
//------------------------------------------------------------------------------
// file		:	"seal.cpp" 
// gestion modules et effets sonores avec seal : 47fps 58 63fps
// fonctions :	seal_init() 
//							seal_initialise(int)
//							seal_chargeModule(int)
//							seal_exec()
//							seal_kill()
//							seal_restaure()
//							seal_joue(unsigned int)
// created		: 1999-09-08
// updates		:	2000-08-15
// copyright	:	2000 TLK GAMES     http://www.tlk.fr
//------------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it under the terms of the 
// GNU General Public License as published by the Free Software Foundation; either version 2 of the License, 
// or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along with this program; 
// if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//******************************************************************************
// liste des fonctions utilisant seal_joue(unsigned int) :
// - New_Element_Tir()	"powermanga sub2.cpp"
// - Add_Ve_Special()		"powermanga sub1.cpp"
// - Add_Explosion()		"powermanga sub2.cpp"
// - bonus_execution()	"bonus.cpp"
// - testBoutonOption() "options.cpp"
//..............................................................................
#include "powermanga.hpp"
//..............................................................................
#ifdef UTILISE_SEAL
//..............................................................................
extern unsigned int				iVerbeux ;										//1=affiche les arguments
extern short							touch[] ;											//tableau des flags des touches du clavier.
extern int								quit_game ;										//true=demande a quitter le jeu
extern bool								aff_game_over ;								//true=affichage du game over en cours
extern bool								player_pause ;								//true=pause en cours
extern int								etat_menu ;										//MENU_OFF(false)=menu inactif ; MENU_ON(true)=menu actif
extern unsigned 	int 		seal_thread_run ;							//1=thread play music running
//constantes ...................................................................
const unsigned int				iNOMBRESONS=28 ;
const unsigned int				iBRUITAGESVOIX=4 ;							//nombre de voix pour les bruitages (avec module)
const unsigned int				iBRUITAGESVOIX2=8 ;						//nombre de voix pour les bruitages (sans module)
//..............................................................................
unsigned int							iBruitagesVoix ;							//nombre de voix pour les bruitages
HAC												pBruitages[iBRUITAGESVOIX2] ;
AUDIOINFO									info;
LPAUDIOMODULE							lpModule;
unsigned int							utilise_seal=1 ;							//1=alors utilise seal
unsigned int							iFlagBruitages[iNOMBRESONS] ;
unsigned int							iFlagMusique ;								//1=alors musique active
int												iNumeroModule ;								//numero du module en cours (0 a n) -1=pas de module charge
int												iNumeroModule2 ;							//numero du module en cours (0 a n) -1=pas de module charge
unsigned int							iChangeSonMusique	;						//1=on active/desactive musique
unsigned int							iVolumeModule ;
unsigned int							iVolumeModule2 ;
unsigned int							iTailleSons ;									//taille des sons
unsigned int						  nDeviceId=0;

//noms des fichiers sons........................................................ 
char*											pFichiersSons[iNOMBRESONS]=
{	"sounds/vchange1.wav",	//0	
	"sounds/vchange2.wav",	//1	
	"sounds/select.wav",		//2	
	"sounds/noselect.wav",	//3
	"sounds/bonus4.wav",		//4
	"sounds/bonus3.wav",		//5
	"sounds/bonus1.wav",		//6
	"sounds/bonus2.wav",		//7
	"sounds/nmispec.wav",		//8
	"sounds/ondechoc.wav",	//9
	"sounds/tir2.wav",			//10
	"sounds/tir1.wav",			//11
	"sounds/xploc1.wav",		//12
	"sounds/xploc2.wav",		//13
	"sounds/xploc3.wav",		//14
	"sounds/xploc4.wav",		//15
	"sounds/xplob1.wav",		//16
	"sounds/xplob2.wav",		//17
	"sounds/xplob3.wav",		//18
	"sounds/xplob4.wav",		//19
	"sounds/xploa1.wav",		//20
	"sounds/xploa2.wav",		//21
	"sounds/xploa3.wav",		//22
	"sounds/xploa4.wav",		//23
	"sounds/tir1nmi.wav",		//24
	"sounds/tir2nmi.wav",		//25
	"sounds/tir3nmi.wav",		//26
	"sounds/tir4nmi.wav"		//27
} ;
//noms des modules utilises ....................................................
char*											pFichiersModules[]=
{
	"sounds/intro.zik",			//0	
	"sounds/game.zik",			//1	
	"sounds/end.zik"				//2	
} ;
//nom des erreurs possibles ....................................................
char* SealErrorText[14]=
{	"AUDIO_ERROR_NONE",                //0x0000
	"AUDIO_ERROR_INVALHANDLE",         //0x0001
	"AUDIO_ERROR_INVALPARAM",          //0x0002
	"AUDIO_ERROR_NOTSUPPORTED",        //0x0003
	"AUDIO_ERROR_BADDEVICEID",         //0x0004
	"AUDIO_ERROR_NODEVICE",            //0x0005
	"AUDIO_ERROR_DEVICEBUSY",          //0x0006
	"AUDIO_ERROR_BADFORMAT",           //0x0007
	"AUDIO_ERROR_NOMEMORY",            //0x0008
	"AUDIO_ERROR_NODRAMMEMORY",        //0x0009
	"AUDIO_ERROR_FILENOTFOUND",        //0x000A
	"AUDIO_ERROR_BADFILEFORMAT",       //0x000B
	"AUDIO_LAST_ERROR",                //0x000C
	"SEAL error was not defined"			 //0x000D
} ;


//..............................................................................
LPAUDIOWAVE								pSons[iNOMBRESONS] ;	 	//structures de tous les sons
unsigned int							fSons[iNOMBRESONS] ;	 	//flag pour chaque son 1=charge
extern unsigned int				iVerbeux ;							//1=verbose mode ; 2=super verbose mode

//prototypes des fonctions loacales ............................................
int		seal_initialise(int) ;
void	seal_restaure() ;
int		seal_chargeModule(int) ;
void	seal_error(char* _pErreur1, char* _pErreur2, int _iErreur) ;
char *locate_data_file(const char *const name) ;

//------------------------------------------------------------------------------
// seal : premiere initialisation
//------------------------------------------------------------------------------
int seal_init()
{	unsigned int i ;
	//unsigned int _iErreur=0 ;
	if (iVerbeux) printf("seal.cpp/seal_init() : start initialization !\n") ;
	if(utilise_seal)
	{	iVolumeModule=64 ;
		iVolumeModule2=64 ;
		iChangeSonMusique=0 ;
		iFlagMusique=1 ;													//1=joue un module
		iBruitagesVoix=iBRUITAGESVOIX ;						//nombre de voix pour les bruitages
		iNumeroModule=-1 ;
		iNumeroModule2=0 ;
		if(AInitialize())													//initialise seal
		{	afficheErreur("Ainitialise() failed", "seal.cpp/seal_init");
			utilise_seal=0 ;
			return 1 ;
		}
	  if (APingAudio(&nDeviceId) != AUDIO_ERROR_NONE)	
		{	if(iVerbeux) afficheErreur("APingAudio() failed : no audio found", "seal.cpp/seal_init") ;
			utilise_seal=0 ;
			return 1 ;
		}

		if(seal_initialise(iNumeroModule2)==FALSE) 
		{	return FALSE ;
		}
		if(utilise_seal==0) return 1 ;

		//charge les fichiers "waves" --------------------------------------------------
		iTailleSons=0 ;														//taille total des sons
		for(i=0 ; i<iNOMBRESONS ; i++)
		{	char* _pNom=pFichiersSons[i] ;
			char *pathname = locate_data_file(_pNom);
			LPAUDIOWAVE* _pSon=&pSons[i] ;
			if(ALoadWaveFile(pathname, _pSon, 0))
			{	afficheErreur(pathname, "Synthetic Audio Library, wave file no found :");
				return FALSE ;
			}
			iTailleSons+=pSons[i]->dwLength ;				//calcul taille total des sons
			fSons[i]=1 ; 														//ok, son charge
		}
	}
		return TRUE ;
}

//------------------------------------------------------------------------------
// seal : initialisations
//------------------------------------------------------------------------------
int seal_initialise(int _iNumeroModule)
{	unsigned int i ;
	if(utilise_seal)
	{	//ouvre le pilote audio 
		info.nDeviceId = AUDIO_DEVICE_MAPPER;
		info.wFormat = AUDIO_FORMAT_16BITS | AUDIO_FORMAT_STEREO;
		info.nSampleRate = 44100;
		if(AOpenAudio(&info)!=AUDIO_ERROR_NONE) 
		{	afficheErreur("AOpenAudio() failed", "seal_initialise/");
			utilise_seal=0 ;
			return TRUE ;
		}
		
		//charge le module en memoire --------------------------------------------------
		if(seal_chargeModule(_iNumeroModule)==FALSE) return FALSE ;
				
		// alloue le nombre de voix necessaire ------------------------------------------	
		if(iFlagMusique) i=lpModule->nTracks+iBruitagesVoix ;
		else i=iBruitagesVoix ;
		if(AOpenVoices(i)) //ouvre un nombre de voix (maxium 32)
		{	afficheErreur("AOpenVoices() failed", "Synthetic Audio Library");
			return FALSE ;
		}

		//alloue des voix supplementaires pour les buitages ----------------------------
		for(i=0 ; i<iBruitagesVoix ; i++)
		{	if(ACreateAudioVoice(&pBruitages[i]))
			{	afficheErreur("ACreateAudioVoice() failed", "Synthetic Audio Library");
				return FALSE ;
			}
			ASetVoiceVolume(pBruitages[i], 64) ;
			ASetVoicePanning(pBruitages[i], 128) ; //stereo panning
		}
		
		if(iFlagMusique)
		{	APlayModule(lpModule);
			ASetModuleVolume(iVolumeModule2);
		}
	}
	for(i=0 ; i<iNOMBRESONS ; i++) iFlagBruitages[i]=0 ;
	return TRUE ;
}

//------------------------------------------------------------------------------
// seal : chargement d'un module
// entree => _iNumeroModule : 0 a n
//------------------------------------------------------------------------------
int seal_chargeModule(int _iNumeroModule) 
{	char* _pNom ;
	int _iErreur;
	if(iFlagMusique) 
	{	if(iNumeroModule>=0)
		{	if(AStopModule() != AUDIO_ERROR_NONE)  afficheErreur("AStopModule() failed", "seal.cpp/seal_chargeModule()") ;						//stop le module
			if(AFreeModuleFile(lpModule) != AUDIO_ERROR_NONE) afficheErreur("AFreeModuleFile() failed", "seal.cpp/seal_chargeModule()") ;						//libere le module
			iNumeroModule=-1 ;
			seal_restaure() ;
			if(seal_initialise(_iNumeroModule)==FALSE) 
			{	return FALSE ;
			}
			return TRUE ;
		}
		
		_pNom=pFichiersModules[_iNumeroModule] ;
		char *pathname = locate_data_file(_pNom);
		_iErreur=ALoadModuleFile(pathname, &lpModule, 0) ;
		if(_iErreur != AUDIO_ERROR_NONE )
		{	seal_error("ALoadModuleFile failed", "seal.cpp/seal_chargeModule()", _iErreur);
			printf("filename: %s\n", pathname) ; 
			return FALSE ;
		}
	iNumeroModule=_iNumeroModule ;
	#ifdef _VERBEUX_
	if(iVerbeux>0) afficheMessage("seal.cpp/seal_chargeModule() loaded module:\n", _pNom) ; 
	#endif
	}
	return TRUE ;
}

//------------------------------------------------------------------------------
// seal : chargement d'un module
// entree => _iNumeroModule : 0 a n
//------------------------------------------------------------------------------
int seal_JoueModule(int _iNumeroModule) 
{	//int _iErreur ;
	iNumeroModule2=_iNumeroModule ;
	if(iFlagMusique) 
	{	if(!seal_chargeModule(_iNumeroModule)) return 1 ;
		else
		{	/*
			if(_iErreur=APlayModule(lpModule) != AUDIO_ERROR_NONE)
				seal_error("APlayModule() failed", "seal.cpp/seal_JoueModule()", _iErreur) ;
			if(_iErreur=ASetModuleVolume(iVolumeModule2) != AUDIO_ERROR_NONE) 
				seal_error("ASetModuleVolume() failed", "seal.cpp/seal_JoueModule()", _iErreur) ;		 
				*/
		}
	}
	//if(AUpdateAudio() != AUDIO_ERROR_NONE) afficheErreur("AUpdateAudio() failed", "seal.cpp/seal_JoueModule()")  ;
	return 0 ;
}

//------------------------------------------------------------------------------
// seal : execution / runtime
//------------------------------------------------------------------------------
void seal_exec()
{	unsigned int i, j ;
	int _iErreur ;
	int iEtatVoix ;
	if(utilise_seal)
	{	AUpdateAudio() ;
	//regle volume du module
	if(iFlagMusique && etat_menu==MENU_OFF && _score::getActionExecution()==0) 
	{	if(!aff_game_over)		//on est dans le jeu ?
		{	if(iVolumeModule2 != iVolumeModule/2)
			{	iVolumeModule2=iVolumeModule/2 ;
				_iErreur=ASetModuleVolume(iVolumeModule2) ; 
				if(ASetModuleVolume(iVolumeModule2) != AUDIO_ERROR_NONE) 
					seal_error("ASetModuleVolume() failed", "seal.cpp/seal_exec()", _iErreur) ;		 
			}
		}
		else
		{	if(iVolumeModule2 != iVolumeModule)
			{	iVolumeModule2=iVolumeModule ;
				_iErreur=ASetModuleVolume(iVolumeModule2) ; 
				if(_iErreur != AUDIO_ERROR_NONE) 
					seal_error("ASetModuleVolume() failed", "seal.cpp/seal_exec()", _iErreur) ;		 
			}
		}
	}
		for(i=0 ; i<iNOMBRESONS ; i++)
		{	if(iFlagBruitages[i])
			{	for(j=0 ; j<iBruitagesVoix ; j++)
				{	AGetVoiceStatus(pBruitages[j], &iEtatVoix) ;
					if(iEtatVoix==1)
					{	iFlagBruitages[i]=0 ;
						APlayVoice(pBruitages[j], pSons[i]);
						goto _saut ;
					}
				}
_saut:;
			}
		}
		if(iChangeSonMusique && !touch[88] && !touch[60]) //touche [ctrl]+[s] relachee ?
		{	iChangeSonMusique=0 ;
			switch(iFlagMusique)
			{	case 0 : //musique inactive, on l'active
				seal_restaure() ;
				iFlagMusique=1 ;
				iBruitagesVoix=iBRUITAGESVOIX ;							//nombre de voix pour les bruitages
				if(seal_initialise(iNumeroModule2)==FALSE) quit_game=1 ;
				APlayModule(lpModule);
				ASetModuleVolume(iVolumeModule);
				break ;
				case 1 : //musique active, on la desactive
				seal_restaure() ;
				iFlagMusique=0 ;
				iBruitagesVoix=iBRUITAGESVOIX2 ;						//nombre de voix pour les bruitages
				if(seal_initialise(iNumeroModule2)==FALSE) quit_game=1 ;
				break ;
			}	
		}
		if (touch[88] && touch[60])		iChangeSonMusique=1 ; //touche [ctrl]+[s] pressee ?
	}
}

//------------------------------------------------------------------------------
// seal : libere tout
//------------------------------------------------------------------------------
void seal_kill()
{	unsigned int i ;
	if(utilise_seal) 
	{	seal_restaure() ;
		for(i=0 ; i<iNOMBRESONS ; i++)
		{	if(fSons[i]==1)							//le son a ete charge ?
			{	AFreeWaveFile(pSons[i]) ;
				fSons[i]=0 ;								//ok, son libere
			}
		}
	}
}

//------------------------------------------------------------------------------
// seal : restaure
//------------------------------------------------------------------------------
void seal_restaure()
{	unsigned int i ;
	if(utilise_seal) 
	{	if(iFlagMusique) AStopModule();				//stop le module
		for(i=0 ; i<iBruitagesVoix ; i++)			//stop les bruitages
		{	AStopVoice(pBruitages[i]);
			ADestroyAudioVoice(pBruitages[i]);
		}
		ACloseVoices();
		if(iFlagMusique && iNumeroModule>=0) 
		{	AFreeModuleFile(lpModule);					//libere le module
			iNumeroModule=-1 ;
		}
		ASetAudioTimerProc(0);
		ACloseAudio();												//ferme le pilote audio
	}
}
//------------------------------------------------------------------------------
// seal : demande a jouer un son
// entree => iNumeroSon : numero du son de 0 a iNOMBRESONS
//------------------------------------------------------------------------------
void	seal_joue(unsigned int iNumeroSon)
{	if(!aff_game_over && !player_pause && _score::getActionExecution()==0 && etat_menu==MENU_OFF)
		iFlagBruitages[iNumeroSon]=1 ;
}

//------------------------------------------------------------------------------
// seal : display error message
// input	=> _pErreur1	: error message 
// 				=> _pErreur2	: error title 
// 				=> _iErreur 	: error number
//------------------------------------------------------------------------------
void seal_error(char* _pErreur1, char* _pErreur2, int _iErreur)
{	if(_iErreur<0 || _iErreur>13) _iErreur=13  ;
	afficheErreur(_pErreur1, _pErreur2, SealErrorText[_iErreur]) ;
}






//..............................................................................
#endif

