%{
/*
 * potool is a program aiding editing of po files
 * Copyright (C) 1999-2000 Zbigniew Chyla
 *
 * see LICENSE for licensing info
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "po-gram.h"
#include "i18n.h"

gint polineno;
gint polex(void);
void poerror(char *s);

static GList *po_entry_list = NULL;
static gchar *concat_strings(GList *slist);
static void free_strings(GList *slist);


%}

%union {
	gint intval;
	gchar *strval;
	GList *glistval;
	po_entry *poval;
	po_comments commentsval;
}

%token MSGID MSGSTR INVALID
%token <strval> STRING
%token <strval> COMMENT_STD
%token <strval> COMMENT_POS
%token <strval> COMMENT_SPECIAL
%token <strval> COMMENT_RESERVED

%type <glistval> string_list
%type <commentsval> comments
%type <poval> msg

%start translation_unit
%%

translation_unit
	: msg_list comments
	;

msg_list
	: msg
	{
		po_entry_list = g_list_append(NULL, $1);
	}
	| msg_list msg
	{
		po_entry_list = g_list_prepend(po_entry_list, $2);
	}
	;

comments
	: /* empty */
	{
		$$.comments_std = NULL;
		$$.comments_pos = NULL;
		$$.comments_spec = NULL;
		$$.comments_res = NULL;
	}
	| comments COMMENT_STD
	{
		$$ = $1;
		$$.comments_std =  g_list_append($$.comments_std, $2);
	}
	| comments COMMENT_POS
	{
		$$ = $1;
		$$.comments_pos =  g_list_append($$.comments_pos, $2);
	}
	| comments COMMENT_SPECIAL
	{
		$$ = $1;
		$$.comments_spec =  g_list_append($$.comments_spec, $2);
	}
	| comments COMMENT_RESERVED
	{
		$$ = $1;
		$$.comments_res =  g_list_append($$.comments_res, $2);
	}
	;

msg
	: comments MSGID string_list MSGSTR string_list
	{
		GList *l;

		$$ = g_new(po_entry, 1);
		$$->id = concat_strings($3);
		$$->str = concat_strings($5);
		$$->comments_std = $1.comments_std;
		$$->comments_pos = $1.comments_pos;
		$$->comments_res = $1.comments_res;
		$$->comments_spec = $1.comments_spec;
		$$->is_fuzzy = $$->is_c_format = 0;
		for ( l = $$->comments_spec; l != NULL; l = g_list_next(l) ) {
			gchar *s = (gchar *) l->data;
			if ( strstr(s, " fuzzy") != NULL ) {
				$$->is_fuzzy = 1;
			}
			if ( strstr(s, " c-format") != NULL ) {
				$$->is_c_format = 1;
			}
		}
		free_strings($3);
		free_strings($5);
	}
	;

string_list
	: STRING
	{
		$$ = g_list_append(NULL, $1);
	}
	| string_list STRING
	{
		$$ = g_list_append($1, $2);
	}
	;

/* ---------- ---------- */

%%
#include <stdio.h>

extern char potext[];
extern int column;

void po_init_parser(void)
{
}

static gchar *concat_strings(GList *slist)
{
	gint total_len;
	gchar *s, *p;
	GList *l;

	for ( total_len = 0, l = slist; l != NULL; l = g_list_next(l) ) {
		total_len += strlen((gchar *) l->data);
	}
	s = g_malloc(total_len + 1);
	for ( p = s, l = slist; l != NULL; l = g_list_next(l) ) {
		int len = strlen((gchar *) l->data);

		if ( len > 0 ) {
			(void) g_memmove(p, (gchar *) l->data, len);
			p += len;
		}
	}
	s[total_len] = '\0';
	return s;
}

static void free_strings(GList *slist)
{
	GList *l;

	for ( l = slist; l != NULL; l = g_list_next(l) ) {
		g_free((gchar *) l->data);
	}
	g_list_free(slist);
}

void poerror(char *s)
{
	fflush(stdout);
	g_error(_("Parse error at line %d\n"), polineno);
}

GList *po_read(gchar *fn)
{
	po_scan_open_file(fn);
	po_init_parser();
	poparse();
	po_scan_close_file();
	return g_list_reverse(po_entry_list);
}
