/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "pxmchem-searchmassopt.h"



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmSearchmassOpt *
pxmchem_searchmassopt_new (void)
{
  PxmSearchmassOpt *smopt = g_malloc0 (sizeof (PxmSearchmassOpt));
  
  smopt->mnm_chement = PXMCHEMENT_MNM_NONE;
  smopt->plm_chement = PXMCHEMENT_PLM_NONE;
  smopt->put_sequence = FALSE;

  return smopt;
}


PxmSearchmassOpt *
pxmchem_searchmassopt_dup (PxmSearchmassOpt *smopt, PxmHowDup how_dup)
{
  PxmSearchmassOpt *smopt_new = g_malloc0 (sizeof (PxmSearchmassOpt));
  
  g_assert (smopt != NULL);
  
  smopt_new->mass = smopt->mass;
  smopt_new->mass_type = smopt->mass_type;

  smopt_new->tolerance = smopt->tolerance;
  smopt_new->tolerance_type = smopt->tolerance_type;

  smopt_new->mnm_chement = smopt->mnm_chement;
  smopt_new->plm_chement = smopt->plm_chement;
  smopt_new->put_sequence = smopt->put_sequence;
  
  return smopt_new;
}


PxmProp *
pxmchem_searchmassopt_prop_dup (PxmProp * prop, PxmHowDup how_dup)
{
  PxmProp *prop_new = NULL;

  g_assert (prop != NULL);
  g_assert (prop->name != NULL);
  g_assert (prop->data != NULL);
  
  prop_new = libpolyxmass_prop_new ();
  
  libpolyxmass_prop_set_name (prop_new, prop->name);
  
  prop_new->data = 
    (gpointer) pxmchem_searchmassopt_dup ((PxmSearchmassOpt *) prop->data,
					  how_dup);
  
  return prop_new;
}


/* UTILITY FUNCTIONS
 */
gboolean
pxmchem_searchmassopt_set_default (PxmSearchmassOpt *smopt)
{
  g_assert (smopt != NULL);
  
  smopt->mass_type = PXM_MASS_MONO;
  
  smopt->tolerance_type = PXM_MASS_TOLERANCE_AMU;

  smopt->mnm_chement = PXMCHEMENT_MNM_NONE;
  smopt->plm_chement = PXMCHEMENT_PLM_NONE;
  smopt->put_sequence = FALSE;

  return TRUE;
}


  

/* FREE'ING FUNCTIONS
 */
gboolean
pxmchem_searchmassopt_free (PxmSearchmassOpt *smopt)
{
  g_assert (smopt != NULL);
  
  g_free (smopt);
  
  return TRUE;
}

gint 
pxmchem_searchmassopt_prop_free (PxmProp *prop)
{
  g_assert (prop != NULL);
  
  if (prop->name != NULL)
    g_free (prop->name);
  
  if (prop->data == NULL)
    return TRUE;
  
  /* Now free the searchmassopt data.
   */
  return pxmchem_searchmassopt_free ((PxmSearchmassOpt *) prop->data);
}


/* GPtrArray-RELATED FUNCTIONS
 */
gint
pxmchem_searchmassopt_GPA_free (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmSearchmassOpt *smopt = NULL;
  

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      smopt = g_ptr_array_remove_index (GPA, 0);
      g_assert (smopt != NULL);
      pxmchem_searchmassopt_free (smopt);
      count++;
    }
  
  g_ptr_array_free (GPA, TRUE);

  return count;
}
