/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef POLYXDEF_UI_POLCHEMDEF_H
#define POLYXDEF_UI_POLCHEMDEF_H

#include "polyxdef-globals.h"
#include "polyxdef-defctxt.h"



GtkWidget *
polyxdef_ui_polchemdef_wnd_setup_window (PxmDefCtxt *defctxt);

void
polyxdef_ui_polchemdef_wnd_editable_changed (GtkWidget *widget,
					     gpointer data);

void
polyxdef_ui_polchemdef_wnd_atomdef_combobox_changed (GtkWidget *widget,
						     gpointer data);

gint
polyxdef_ui_polchemdef_wnd_fill_atom_defs_combo_list (PxmDefCtxt *defctxt);

gboolean
polyxdef_ui_polchemdef_wnd_set_atomdef_name_to_combo_list (PxmDefCtxt *
							   defctxt);

gboolean
polyxdef_ui_polchemdef_wnd_atom_definition_read_button (GtkWidget *widget, 
							gpointer data);

void
polyxdef_ui_polchemdef_wnd_atom_definition_locate_button (GtkWidget *widget, 
							gpointer data);


/* SYNTAX ERROR CHECKING FUNCTIONS
 */
gboolean
polyxdef_ui_polchemdef_wnd_polchemdef_check_syntax_button (GtkWidget *widget,
							   gpointer data);


/* SAVE BUTTONS
 */
void
polyxdef_ui_polchemdef_wnd_polchemdef_save_button (GtkWidget *widget, 
						   gpointer data);

void
polyxdef_ui_polchemdef_wnd_polchemdef_saveas_button (GtkWidget *widget,
						     gpointer data);


/* HELPERS
 */
void
polyxdef_ui_polchemdef_wnd_update_status_label (PxmDefCtxt *defctxt);



/* WINDOW CLOSING FUNCTIONS
 */
gboolean
polyxdef_ui_polchemdef_wnd_polchemdef_wnd_delete_event (GtkWidget *window,
							GdkEvent *event,
							gpointer data);

gboolean
polyxdef_ui_polchemdef_wnd_polchemdef_wnd_destroy_event (GtkWidget *window,
							 GdkEvent *event,
							 gpointer data);






















GtkWidget *
polyxdef_ui_polchemdef_wnd_setup_window (PxmDefCtxt *defctxt);

void
polyxdef_polchemdef_editable_changed (GtkWidget *widget,
				  gpointer data);

void
polyxdef_atomdef_combobox_changed (GtkWidget *widget,
				   gpointer data);

gint
polyxdef_ui_polchemdef_wnd_fill_atom_defs_combo_list (PxmDefCtxt *defctxt);

gboolean
polyxdef_ui_polchemdef_wnd_set_atomdef_name_to_combo_list (PxmDefCtxt *defctxt);

gboolean
polyxdef_ui_polchemdef_wnd_atom_definition_read_button (GtkWidget *widget, 
							gpointer data);

void
polyxdef_ui_polchemdef_wnd_atom_definition_locate_button (GtkWidget *widget, 
							  gpointer data);

void
polyxdef_ui_polchemdef_wnd_update_status_label (PxmDefCtxt *defctxt);



/* SYNTAX ERROR CHECKING FUNCTIONS
 */
gboolean
polyxdef_polchemdef_check_syntax_button (GtkWidget *widget, 
				     gpointer data);


/*
  POLYMER DEFINITION SAVING FUNCTIONS
*/
void
polyxdef_polchemdef_save_button (GtkWidget *widget, 
			     gpointer data);


void
polyxdef_polchemdef_saveas_button (GtkWidget *widget, 
			       gpointer data);


gboolean
polyxdef_save_polchemdef_from_fileselection (GtkWidget *widget, 
					 gpointer data);

gboolean
polyxdef_save_polchemdef_to_file (PxmPolchemdef *polchemdef, gchar *file);


/* HELPERS
 */
void
polyxdef_ui_polchemdef_wnd_update_status_label (PxmDefCtxt *defctxt);







gboolean
polyxdef_open_polchemdef_file (gchar *file);



/* WINDOW CLOSING FUNCTIONS
 */
gboolean
polyxdef_polchemdef_wnd_delete_event (GtkWidget *window,
				  GdkEvent *event,
				  gpointer data);

gboolean
polyxdef_polchemdef_wnd_destroy_event (GtkWidget *window,
				  GdkEvent *event,
				  gpointer data);










#endif /* ifndef POLYXDEF_UI_POLCHEMDEF_H */
