------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                                F L A G S                                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2005-2008, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;

package Flags is

   Main_Source      : Types.Name_Id := Types.No_Name;
   --  IDL source name

   Print_On_Stdout  : Boolean       := False;
   --  True when we want to generate sources in the standard output

   Print_Full_Tree  : Boolean       := False;
   --  Output tree

   Preprocess_Only  : Boolean       := False;
   --  True when we only preprocess the IDL source file and output it

   No_Preprocess    : Boolean       := False;
   --  No preprocessing pass, assume input file has already been preprocessed

   Compile_Only     : Boolean       := False;
   --  True when we only compile the IDL source file and exit

   Output_Directory : String_Ptr    := null;
   --  The output directory

   Quiet            : Boolean       := False;
   --  Quiet mode: no output unless warnings or errors need to be displayed

end Flags;
