from util import *
import gen

""" This file contains functions for accessing those resources that
play a specified role wrt some recognizer. Where we can guarantee that
recognizer A is run before recognizer B, we can find B players by invoking
"get" to retrieve players associated with A."""

def get (recogObj, roleStr, instances = None) :
    """ Returns classes playing roleStr role wrt recogObj recognizer. """
    if instances == None:
        instances = PRGM.pattern_instances[recogObj.__name__]
    #print gen.get_collabs(recogObj)
    if roleStr in gen.get_collabs(recogObj):
        if roleStr == recogObj.focus_name:
            roleStr = "obj"
        return flatten([walk_instance(ins, roleStr) for ins in instances])
    else:
        print roleStr + " is not a role for " + recogObj.__name__
        return []

def walk_instance (Player, roleStr):
    """ Utility for walking a Player tree in search of those classes that
    play roleStr role"""
    return walk_instance_aux(Player, roleStr)

def walk_instance_aux(Player, roleStr):
    """ Utility to be used with walk_instance """
    ans = []
    if Player.__class__.__name__ == "Aggr":
        for next in Player.elements:
            ans.append(walk_instance_aux(next, roleStr))
    elif Player.__class__.__name__ == "Player":
         if roleStr == Player.pattern_role:
            ans.append([Player.focus])
         else:
            #go deeper
            accessors = Player.with.keys()
            if roleStr in accessors:
                 ans.append(flatten([walk_instance_aux(s, roleStr) \
                                    for s in Player.with[roleStr]]))
            else:
              #go deeper
              for key in accessors:
                  for next in Player.with[key]:
                      ans.append(walk_instance_aux(next, roleStr))
    return flatten(ans)
