from util import *
from pi import *
"""This file contains policy statement assertions along with comments that document underlying track evidence.  For some pattern instances, resources participating in the pattern have been assigned a new type so that psttern constraints can be maintained. For each pattern instance the policy author may take one of three action - accept the assertion as is, select individual "allows" using the automatically gneerated types , or select individual "allows" using the original types.  The author should make sure that the desired assertions are uncommented. """
############ New Types ####################

# If any of these are removed, also replace deleted type in any of the assertions below
Declare("__ecommerce_Pipeline1_t","file_type");
Declare("__ecommerce_Pipeline2_t","file_type");

################### Individual Allows #################

# </usr/lib/python2.3/sre_constants.pyc-->esales.py>
# </usr/lib/python2.3/site.pyc-->esales.py>
# </usr/lib/python2.3/encodings/aliases.pyc-->esales.py>
# </usr/lib/python2.3/fpformat.pyc-->esales.py>
# </usr/lib/python2.3/random.pyc-->esales.py>
# </usr/lib/python2.3/os.pyc-->esales.py>
# </usr/lib/python2.3/warnings.pyc-->esales.py>
# </usr/lib/python2.3/UserDict.pyc-->esales.py>
# </usr/lib/python2.3/stat.pyc-->esales.py>
# </usr/lib/python2.3/site-packages/pygtk.pth-->esales.py>
# </usr/lib/python2.3/socket.py-->esales.py>
# </usr/lib/python2.3/re.pyc-->esales.py>
# </usr/lib/python2.3/site-packages/japanese.pth-->esales.py>
# </usr/lib/python2.3/sre_compile.pyc-->esales.py>
# </usr/lib/python2.3/lib-dynload/japanese/__init__.pyc-->esales.py>
# </usr/lib/python2.3/copy_reg.pyc-->esales.py>
# </usr/lib/python2.3/socket.pyc-->esales.py>
# </usr/lib/python2.3/types.pyc-->esales.py>
# </usr/lib/python2.3/sre_parse.pyc-->esales.py>
# </usr/lib/python2.3/lib-dynload/japanese/aliases/__init__.pyc-->esales.py>
# </usr/lib/python2.3/posixpath.pyc-->esales.py>
# </usr/lib/python2.3/sre.pyc-->esales.py>
# </usr/lib/python2.3/codecs.pyc-->esales.py>
# </usr/lib/python2.3/string.pyc-->esales.py>
# </usr/lib/python2.3/encodings/__init__.pyc-->esales.py>
# </usr/lib/python2.3/linecache.pyc-->esales.py>
# </usr/lib/python2.3/encodings/utf_8.pyc-->esales.py>
AllowInstance('root:system_r:ecomm_esales_t','system_u:object_r:lib_t','File','read')

# <acct_rcv.py-->/usr/bin/python>
AllowInstance('root:system_r:ecomm_acct_rcv_t','system_u:object_r:bin_t','File','exec')

# <./esales.py-->esales.py>
AllowInstance('root:system_r:ecomm_esales_t','system_u:object_r:ecomm_esales_exec_t','File','read')

# </proc/meminfo-->esales.py>
AllowInstance('root:system_r:ecomm_esales_t','system_u:object_r:proc_t','File','read')

# </proc/meminfo-->acct_rcv.py>
AllowInstance('root:system_r:ecomm_acct_rcv_t','system_u:object_r:proc_t','File','read')

# </usr/lib/python2.3/site.pyc-->acct_rcv.py>
# </usr/lib/python2.3/encodings/aliases.pyc-->acct_rcv.py>
# </usr/lib/python2.3/os.pyc-->acct_rcv.py>
# </usr/lib/python2.3/warnings.pyc-->acct_rcv.py>
# </usr/lib/python2.3/UserDict.pyc-->acct_rcv.py>
# </usr/lib/python2.3/stat.pyc-->acct_rcv.py>
# </usr/lib/python2.3/site-packages/pygtk.pth-->acct_rcv.py>
# </usr/lib/python2.3/site-packages/japanese.pth-->acct_rcv.py>
# </usr/lib/python2.3/lib-dynload/japanese/__init__.pyc-->acct_rcv.py>
# </usr/lib/python2.3/copy_reg.pyc-->acct_rcv.py>
# </usr/lib/python2.3/types.pyc-->acct_rcv.py>
# </usr/lib/python2.3/lib-dynload/japanese/aliases/__init__.pyc-->acct_rcv.py>
# </usr/lib/python2.3/posixpath.pyc-->acct_rcv.py>
# </usr/lib/python2.3/codecs.pyc-->acct_rcv.py>
# </usr/lib/python2.3/encodings/__init__.pyc-->acct_rcv.py>
# </usr/lib/python2.3/linecache.pyc-->acct_rcv.py>
# </usr/lib/python2.3/encodings/utf_8.pyc-->acct_rcv.py>
AllowInstance('root:system_r:ecomm_acct_rcv_t','system_u:object_r:lib_t','File','read')

# <acct_rcv.py-->/usr/lib/python2.3/site-packages>
AllowInstance('root:system_r:ecomm_acct_rcv_t','system_u:object_r:lib_t','Dir','open')

# <esales.py-->/usr/bin/python>
AllowInstance('root:system_r:ecomm_esales_t','system_u:object_r:bin_t','File','exec')

# <./shipping.py-->shipping.py>
AllowInstance('root:system_r:ecomm_shipping_t','system_u:object_r:ecomm_shipping_exec_t','File','read')

# <./acct_rcv.py-->acct_rcv.py>
AllowInstance('root:system_r:ecomm_acct_rcv_t','system_u:object_r:ecomm_acct_rcv_exec_t','File','read')

# </proc/meminfo-->shipping.py>
AllowInstance('root:system_r:ecomm_shipping_t','system_u:object_r:proc_t','File','read')

# <shipping.py-->/usr/lib/python2.3/site-packages>
AllowInstance('root:system_r:ecomm_shipping_t','system_u:object_r:lib_t','Dir','open')

# <shipping.py-->/usr/bin/python>
AllowInstance('root:system_r:ecomm_shipping_t','system_u:object_r:bin_t','File','exec')

# <acct_rcv.py-->/usr/share/ecomm/orders>
AllowInstance('root:system_r:ecomm_acct_rcv_t','system_u:object_r:ecomm_new_orders_dir_t','Dir','open')

# </usr/lib/python2.3/site.pyc-->shipping.py>
# </usr/lib/python2.3/encodings/aliases.pyc-->shipping.py>
# </usr/lib/python2.3/os.pyc-->shipping.py>
# </usr/lib/python2.3/warnings.pyc-->shipping.py>
# </usr/lib/python2.3/UserDict.pyc-->shipping.py>
# </usr/lib/python2.3/stat.pyc-->shipping.py>
# </usr/lib/python2.3/site-packages/pygtk.pth-->shipping.py>
# </usr/lib/python2.3/site-packages/japanese.pth-->shipping.py>
# </usr/lib/python2.3/lib-dynload/japanese/__init__.pyc-->shipping.py>
# </usr/lib/python2.3/copy_reg.pyc-->shipping.py>
# </usr/lib/python2.3/types.pyc-->shipping.py>
# </usr/lib/python2.3/lib-dynload/japanese/aliases/__init__.pyc-->shipping.py>
# </usr/lib/python2.3/posixpath.pyc-->shipping.py>
# </usr/lib/python2.3/codecs.pyc-->shipping.py>
# </usr/lib/python2.3/encodings/__init__.pyc-->shipping.py>
# </usr/lib/python2.3/linecache.pyc-->shipping.py>
# </usr/lib/python2.3/encodings/utf_8.pyc-->shipping.py>
AllowInstance('root:system_r:ecomm_shipping_t','system_u:object_r:lib_t','File','read')

# <shipping.py-->/usr/share/ecomm/paid>
AllowInstance('root:system_r:ecomm_shipping_t','system_u:object_r:ecomm_paid_orders_dir_t','Dir','open')

# <esales.py-->/usr/lib/python2.3/site-packages>
AllowInstance('root:system_r:ecomm_esales_t','system_u:object_r:lib_t','Dir','open')

# shipping.py execs ['./shipping.py', '/usr/bin/python']
CanExec(['root:system_r:ecomm_shipping_t', 'system_u:object_r:ecomm_shipping_exec_t', 'system_u:object_r:bin_t'])
# esales.py execs ['./esales.py', '/usr/bin/python']
CanExec(['root:system_r:ecomm_esales_t', 'system_u:object_r:ecomm_esales_exec_t', 'system_u:object_r:bin_t'])
# acct_rcv.py execs ['./acct_rcv.py', '/usr/bin/python']
CanExec(['root:system_r:ecomm_acct_rcv_t', 'system_u:object_r:ecomm_acct_rcv_exec_t', 'system_u:object_r:bin_t'])
##################### Pattern Instances ####################

# Select entire pattern or select individual assertions
#---- Pipeline---
#Evidence: Pipeline ['esales.py', '/usr/share/ecomm/orders/10988928243867', 'acct_rcv.py', '/usr/share/ecomm/paid/10988928243867', 'shipping.py']
#allow  ecomm_esales_t  ecomm_new_orders_dir_t: file   write;
#allow  ecomm_acct_rcv_t  ecomm_new_orders_dir_t: file   {read getattr};
#allow  ecomm_acct_rcv_t  ecomm_paid_orders_dir_t: file   write;
#allow  ecomm_shipping_t  ecomm_paid_orders_dir_t: file   {read getattr};

#PipelineInstance('root:system_r:ecomm_esales_t', 'root:object_r:ecomm_new_orders_dir_t', 'root:system_r:ecomm_acct_rcv_t', 'root:object_r:ecomm_paid_orders_dir_t', 'root:system_r:ecomm_shipping_t')
#allow  ecomm_esales_t  __ecommerce_Pipeline1_t: file   write;
#allow  ecomm_acct_rcv_t  __ecommerce_Pipeline1_t: file   {read getattr};
#allow  ecomm_acct_rcv_t  __ecommerce_Pipeline2_t: file   write;
#allow  ecomm_shipping_t  __ecommerce_Pipeline2_t: file   {read getattr};

PipelineInstance('root:system_r:ecomm_esales_t', '__ecommerce_Pipeline1_t', 'root:system_r:ecomm_acct_rcv_t', '__ecommerce_Pipeline2_t', 'root:system_r:ecomm_shipping_t')
#---- SharedLibrary---
#allow  ecomm_shipping_t  shlib_t: file   {read getattr};

SharedLibraryInstance('root:system_r:ecomm_shipping_t', 'system_u:object_r:shlib_t')
#allow  ecomm_esales_t  shlib_t: file   {read getattr};

SharedLibraryInstance('root:system_r:ecomm_esales_t', 'system_u:object_r:shlib_t')
#allow  ecomm_acct_rcv_t  shlib_t: file   {read getattr};

SharedLibraryInstance('root:system_r:ecomm_acct_rcv_t', 'system_u:object_r:shlib_t')
#---- Config---
#allow  ecomm_shipping_t  etc_runtime_t: file   {read getattr};

ConfigInstance('root:system_r:ecomm_shipping_t', 'system_u:object_r:etc_runtime_t')
#allow  ecomm_esales_t  locale_t: file   {read getattr};

ConfigInstance('root:system_r:ecomm_esales_t', 'system_u:object_r:locale_t')
#allow  ecomm_esales_t  etc_runtime_t: file   {read getattr};

ConfigInstance('root:system_r:ecomm_esales_t', 'system_u:object_r:etc_runtime_t')
#allow  ecomm_acct_rcv_t  etc_runtime_t: file   {read getattr};

ConfigInstance('root:system_r:ecomm_acct_rcv_t', 'system_u:object_r:etc_runtime_t')
#---- Mediator---
gen_te()