/*
 * $Id: detailsform.c,v 1.22 2001/10/27 18:56:41 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "debug.h"
#include "detailsform.h"
#include "document.h"
#include "externalform.h"
#include "history.h"
#include "image.h"
#include "link.h"
#include "prefsdata.h"
#include "resourceids.h"
#include "util.h"



static void AddDocNameTitle
    (
    Char* name
    )
{
    FontID oldFont; 

    oldFont = FntSetFont( boldFont );
    WinDrawChars( name, StrLen( name ), 
        ( 160 - FntCharsWidth( name, StrLen( name ) ) ) / 2, 20 );
    FntSetFont( oldFont );
}



/* Initialize the details form */
static void DetailsFormInit( void )
{
    FormType*   detailsForm;
    FieldType*  urlField;
    Int16       reference;

    detailsForm = FrmGetFormPtr( frmDetails );
    urlField    = (FieldType*) GetObjectPtr( frmDetailsLink );
    reference   = GetHistoryCurrent();

    AddURLToField( urlField, reference );
    FrmDrawForm( detailsForm );

    AddDocNameTitle( Prefs()->docName );

    CtlSetValue( (ControlType*) GetObjectPtr( frmDetailsStatusRead ), LinkVisited( reference ) );
    CtlSetValue( (ControlType*) GetObjectPtr( frmDetailsStatusUnread ), ! LinkVisited( reference ) );

    CtlSetValue( (ControlType*) GetObjectPtr( frmDetailsShowImages ), ShowImages( reference ) );
}



/* Event handler for the details form */
Boolean DetailsFormHandleEvent
    (
    const EventType* event  /* pointer to an EventType structure */
    )
{
    Boolean handled;
    Boolean updatePage;

    SET_A4_FROM_A5 

    handled = false;
    updatePage = false;

    switch ( event->eType ) {
        case ctlSelectEvent:
            if ( event->data.ctlEnter.controlID == frmDetailsOK ) {
                Int16   reference;
                Boolean oldStatus;
                Boolean newStatus;

                reference   = GetHistoryCurrent();
                oldStatus   = ShowImages( reference );
                newStatus   = CtlGetValue( (ControlType*) GetObjectPtr( frmDetailsShowImages ) );
                updatePage  = oldStatus ^ newStatus;

                if ( newStatus )
                    ShowImagesOn( reference );
                else
                    ShowImagesOff( reference );

                if ( CtlGetValue( (ControlType*) GetObjectPtr( frmDetailsStatusRead ) ) )
                    SetVisitedLink( reference );
                else
                    UnsetVisitedLink( reference );

            }
            else if ( event->data.ctlEnter.controlID == frmDetailsCopy ) {
                FieldType* field;

                field = (FieldType*) GetObjectPtr( frmDetailsLink );
                WriteMemo( field );
            }
            else if ( event->data.ctlEnter.controlID != frmDetailsCancel )
                break;

            FrmReturnToForm( Prefs()->toolbar );
            if ( updatePage ) {
                ResetHeight();
                FrmUpdateForm( Prefs()->toolbar, frmRedrawUpdateCode );
            }
            handled = true;
            break;

        case frmOpenEvent:
            DetailsFormInit();
            handled = true;
            break;

        case frmCloseEvent:
            handled = false;
            break;

        default:
            handled = false;
    }

    RESTORE_A4 

    return handled;
}
