/*
 * $Id: buttonform.c,v 1.4 2001/09/16 15:07:37 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "debug.h"
#include "prefsdata.h"
#include "buttonform.h"
#include "resourceids.h"
#include "util.h"


static void ButtonFormInit( void ) PLKRDB_SECTION;


/***********************************************************************
 *
 *      Internal Constants
 *
 ***********************************************************************/
#define SELECTED 1

/***********************************************************************
 *
 *      Private variables
 *
 ***********************************************************************/
static SelectType hwMode[ NUM_OF_HW_BUTTONS ];



/* Initialize the preference form */
static void ButtonFormInit( void )
{
    ListType*       list;
    ControlType*    ctl;
    UInt16          selection;
    FormType*       prefsForm;

    prefsForm = FrmGetFormPtr( frmButton );

    MemMove( hwMode, Prefs()->hwMode, sizeof( hwMode ) );

    FrmDrawForm( prefsForm );

    CtlSetValue( (ControlType*) GetObjectPtr( frmButtonHardKeys ), Prefs()->hardKeys );

    list        = (ListType*) GetObjectPtr( frmButtonActionList );
    ctl         = (ControlType*) GetObjectPtr( frmButtonSelectAction );
    selection   = hwMode[ DATEBOOK_BUTTON ];

    LstSetSelection( list, selection );
    CtlSetLabel( ctl, LstGetSelectionText( list, selection ) );

    CtlSetValue( (ControlType*) GetObjectPtr( frmDatebookButton ), true );
}



/* Event handler for the preference form */
Boolean ButtonFormHandleEvent
    (
    const EventType* event  /* pointer to an EventType structure */
    )
{
    ListType*       list;
    ControlType*    ctl;
    Int16           selection;
    Boolean         handled;

    handled = false;

    SET_A4_FROM_A5 

    switch ( event->eType ) {
        case ctlSelectEvent:
            switch ( event->data.ctlEnter.controlID ) {
                case frmDatebookButton:
                case frmAddressButton:
                case frmTodoButton:
                case frmMemoButton:
                    list        = (ListType*) GetObjectPtr( frmButtonActionList );
                    ctl         = (ControlType*) GetObjectPtr( frmButtonSelectAction );
                    selection   = hwMode[ event->data.ctlEnter.controlID - frmDatebookButton ];

                    LstSetSelection( list, selection );
                    CtlSetLabel( ctl, LstGetSelectionText( list, selection ) );
                    break;

                case frmButtonSelectAction:
                    list        = (ListType*) GetObjectPtr( frmButtonActionList );
                    selection   = LstPopupList( list );
                    if ( selection != noListSelection ) {
                        ControlType*    ctl;
                        Char*           label;

                        ctl     = (ControlType*) GetObjectPtr( event->data.ctlEnter.controlID );
                        label   = LstGetSelectionText( list, selection );

                        CtlSetLabel( ctl, label );
                        LstSetSelection( list, selection );

                        if ( CtlGetValue( (ControlType*) GetObjectPtr( frmDatebookButton ) ) == SELECTED )
                            hwMode[ DATEBOOK_BUTTON ] = (SelectType) LstGetSelection( list );
                        else if ( CtlGetValue( (ControlType*) GetObjectPtr( frmAddressButton ) ) == SELECTED )
                            hwMode[ ADDRESS_BUTTON ] = (SelectType) LstGetSelection( list );
                        else if ( CtlGetValue( (ControlType*) GetObjectPtr( frmTodoButton ) ) == SELECTED )
                            hwMode[ TODO_BUTTON ] = (SelectType) LstGetSelection( list );
                        else if ( CtlGetValue( (ControlType*) GetObjectPtr( frmMemoButton ) ) == SELECTED )
                            hwMode[ MEMO_BUTTON ] = (SelectType) LstGetSelection( list );

                        if ( CtlGetValue( (ControlType*) GetObjectPtr( frmButtonHardKeys ) ) == false && 
                             selection != SELECT_NONE ) {
                            Prefs()->hardKeys = true;
                            CtlSetValue( (ControlType*) GetObjectPtr( frmButtonHardKeys ), true );
                        }
                        if ( ( hwMode[ DATEBOOK_BUTTON ] | hwMode[ ADDRESS_BUTTON ] | hwMode[ TODO_BUTTON ] | hwMode[ MEMO_BUTTON ] ) == SELECT_NONE ) {
                            Prefs()->hardKeys = false;
                            CtlSetValue( (ControlType*) GetObjectPtr( frmButtonHardKeys ), false );
                        }
                    }
                    break;

                case frmButtonOK:
                    Prefs()->hardKeys = CtlGetValue( (ControlType*) GetObjectPtr( frmButtonHardKeys ) );

                    MemMove( Prefs()->hwMode, hwMode, sizeof( hwMode ) );
                    FrmReturnToForm( Prefs()->lastForm );
                    handled = true;
                    break;

                case frmButtonCancel:
                    FrmReturnToForm( Prefs()->lastForm );
                    handled = true;
                    break;

                default:
                    break;
            }
            break;

        case frmOpenEvent:
            ButtonFormInit();
            handled = true;
            break;

        default:
            handled = false;
    }

    RESTORE_A4 

    return handled;
}
