#
# This module is designed to use Xerox PARC's code_timer software to do
# profiling of the Plucker parser.  That code, however, is proprietary to
# Xerox, and is not included with the Plucker sources.  To avoid problems
# caused by that absence, this code redefines the few exported functions
# with null stubs when code_timer is not available.

try:
    import code_timer
    CodeTimerOn = code_timer.CodeTimerOn
    StartInterval = code_timer.StartInt
    StopInterval = code_timer.StopInt
    PrintTable = code_timer.PrintTable
except:
    CodeTimerOn = lambda: None
    StartInterval = lambda x, y: None
    StopInterval = lambda x, y: None
    PrintTable = lambda x, y: None
