/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * 翻訳単語のトレース調査を行うための辞書クラスです。
 * pleiades-config.xml に指定したトレース対象に一致したときの状態をトレースします。
 * <p>
 * @author cypher256
 */
public class TraceableTranslationDictionary extends DynamicTranslationDictionary {

	/** ロガー */
	private static final Logger log = Logger.getLogger(TraceableTranslationDictionary.class);
	private final String traceWord;
	private final boolean traceIsJa;

	/**
	 * トレース翻訳辞書を構築します。
	 */
	public TraceableTranslationDictionary() {
		PleiadesConfig config = PleiadesConfig.getInstance();
		traceWord = config.getProperty("trace.word");
		traceIsJa = Boolean.valueOf(config.getProperty("trace.is.ja"));
		log.warn("トレース翻訳辞書を生成しました。traceWord=%s, traceIsJa=%s", traceWord, traceIsJa);
	}

	@Override
	protected String lookupInternal(String en, JointPoint jointPoint) {

		String ja = super.lookupInternal(en, jointPoint);

		String target = traceIsJa ? ja : en;
		if (target.matches(traceWord)) {
			String s = System.currentTimeMillis() + "「" + en + "」→「" + ja + "」";
			log.debug(new Exception(s), "デバッグ翻訳追跡スタックトレース jointPoint:" + jointPoint);
			return s;
		}
		return ja;
	}
}
