/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file timer_kill_players.hpp
 * \brief The class describing a timer item.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_TIMER_KILL_PLAYERS_HPP__
#define __PTB_TIMER_KILL_PLAYERS_HPP__

#include "communication/typed_message.hpp"
#include "engine/base_item.hpp"
#include "engine/messageable_item.hpp"
#include "universe/derived_item_handle.hpp"
#include "ptb/item/plee/plee.hpp"
#include "engine/export.hpp"

namespace ptb
{
  /**
   * \brief The class describing a timer object that kill players 
   * when the countdown is finish.
   * \author Sbastien Angibaud
   * The custom fields of this class are :
   *  - \a name: \c The name of the item,
   *  - \a countdown: \c Indicates if the timer is a countdown,
   *  - \a time: \c The initial time.
   */
  class timer_kill_players:
    public bear::engine::messageable_item< bear::engine::base_item >
  {
    DECLARE_BASE_ITEM(timer_kill_players, ptb);
 
  public:
    /** \brief The type of the parent class. */
    typedef bear::engine::messageable_item<bear::engine::base_item> super;

    /*----------------------------------------------------------------------*/
    /**
     * \brief A message to get the value of the timer.
     * \author Julien Jorge
     */
    class msg_get_value:
      public bear::communication::typed_message<timer_kill_players>
    {
    public:
      bool apply_to( timer_kill_players& that );

    public:
      /** \brief The value of the timer. */
      bear::universe::time_type value;

      /** \brief Indicates if the timer is a countdown. */
      bool countdown;

    }; // class msg_get_value()

  public:
    timer_kill_players();

    void build();
    void progress( bear::universe::time_type elapsed_time );
    bool set_bool_field( const std::string& name, bool value );
    bool set_u_integer_field( const std::string& name, unsigned int value );

    bool is_valid() const;

    bear::universe::time_type get_time() const;
    bool get_countdown() const;
  
  private:
    void finish_countdown();
    void search_players();

  private:
    /** \brief The real time. */
    bear::universe::time_type m_time;

    /** \brief The save of the time at the beginning. */
    bear::universe::time_type m_save_time;

    /** \brief Indicates if the timer is a countdown. */
    bool m_countdown;

    /** \brief The first player. */
    bear::universe::const_derived_item_handle_maker<plee>::handle_type
    m_first_player;

    /** \brief The second player. */
    bear::universe::const_derived_item_handle_maker<plee>::handle_type
    m_second_player;
  }; // class timer_kill_players
} // namespace bear

#endif // __PTB_TIMER_KILL_PLAYERS_HPP__
