;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../../common.scm")

(let ( (src_name "linker.xcf.bz2")
       (dest_name "linker.png")
       (dest_name_off "linker-off.png") )
  (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
         (dest_image_off (car (gimp-image-new 256 128 RGB)))
         (dest_image (car (gimp-image-new 512 128 RGB)))
         )
    (let ( (bk (car (gimp-layer-new dest_image 512 128 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )
    (let ( (bk (car (gimp-layer-new
                     dest_image_off 256 128 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image_off bk 0)
      )

    (let ( (right_halo 0)
           (right_light_on 1)
           (right_light_off 2)
           (left_halo 3)
           (left_light_on 4)
           (left_light_off 5)
           (rope 6)
           (hook 7)
           (plinth 8)
           (block 9) )

      (create-layer src_image 
                    (list hook plinth block right_light_off left_light_off)
                    0 0 142 128 dest_image_off)
      (create-layer src_image 
                    (list hook plinth block rope right_light_off left_light_off)
                    0 0 142 128 dest_image)
      (create-layer src_image 
                    (list hook plinth block rope right_light_off left_light_on
                          left_halo)
                    142 0 142 128 dest_image)
      (create-layer src_image 
                    (list hook plinth block rope right_light_on right_halo
                          left_light_on left_halo)
                    284 0 142 128 dest_image)
      ) ; let

    (save-frames dest_name_off dest_image_off)
    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
