/*	Styled_Writer

PIRL CVS ID: Styled_Writer.java,v 1.4 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Utilities;

import	javax.swing.text.AttributeSet;
import	java.io.IOException;

/**	A <i>Styled_Writer</i> is used to write styled text.
<p>
	This interface is used to write text that may have various text style
	attributes - font face, size, color, etc. - associated with it.
<p>
	@author		Bradford Castalia - UA/PIRL
	@version	1.4
*/
public interface Styled_Writer
{
/**	Write styled text.
<p>
	A style may be assembled using combinations of the numerous
	StyleConstants setXXX functions applied to a SimpleAttributeSet. For
	example:
<p>
<code><pre>
SimpleAttributeSet bold_red_text = new SimpleAttributeSet ();
StyleConstants.setBold       (bold_red_text, true);
StyleConstants.setForeground (bold_red_text, Color.RED);
StyleConstants.setFontFamily (bold_red_text, "Monospaced");
</pre></code>
<p>
	assembles a style that will produce text in a bold, red, monospaced
	font.
<p>
	@param	text	The text String to be written.
	@param	style	The AttributeSet to be applied to the text. This
		may be null if plain text is to be displayed.
	@return	This Styled_Writer
	@see	javax.swing.text.StyleConstants
	@see	javax.swing.text.SimpleAttributeSet
*/
public Styled_Writer Write
	(
	String			text,
	AttributeSet	style
	)
	throws IOException;

/**	Write plain text.
<p>
	This is the same as {@link #Write(String, AttributeSet) writing}
	text will a null style.
<p>
	@param	text	The text String to be written.
	@return	This Styled_Writer
*/
public Styled_Writer Write
	(
	String			text
	)
	throws IOException;

}
