/*	Parameter_test

CVS ID: Parameter_test.java,v 1.9 2012/04/16 06:14:24 castalia Exp

Copyright (C) 2003-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.PVL.*;

import	java.io.File;
import	java.io.FileOutputStream;
import	java.util.Iterator;
import	java.util.ListIterator;
import	java.util.NoSuchElementException;
import	java.util.Vector;
import	java.io.ByteArrayOutputStream;


public class Parameter_test
{

public static void main (String[] arguments) 
{
System.out.println ("*** " + Parameter.ID);
try
	{
	String
		parameters_string =
			"Group = TOP\n" +
			"	TOP_1 = 1\n" +
			"	Object = SUB_A\n" +
			"		SUB_A1 = 1.0\n" +
			"		SUB_A2 = 2.0\n" +
			"		SUB_A3 = 3.0\n" +
			"	End_Object = SUB_A\n" +
			"	Group = SUB_B\n" +
			"		SUB_B1 = one\n" +
			"		SUB_B2 = (two, 2, to, too)\n" +
			"	End_Object /* should be End_Group */ = SUB_B\n" +
			"	Object = TOP_1\n" +
			"	End_Object = TOP_1\n" +
			"End_Group = TOP\n";
	Parameter
		parameters,
		new_param,
		param;
	int
		param_class,
		count;
	boolean
		test;


	System.out.println ("--- parameters_string:");
	System.out.println (parameters_string);
	System.out.println
		("--- Constructing parameters from the String:\n"
		+ "\tparameters = new Parameter (\"PVL.test\", new Parser (parameters_string));");
	//	Constructor: String Parser
	parameters = new Parameter ("PVL.test", new Parser (parameters_string));
	if (parameters.Warning () != null)
		{
		System.out.println (parameters.Warning ().getMessage ());
		System.out.println ("*** Aggregate enclosure mismatch expected.");
		}
	else
		System.out.println ("!!! Aggregate enclosure mismatch expected.");

	System.out.println
		("--- parameters.Description ()");
	System.out.println (parameters.Description ());
	System.out.println
		("--- parameters.Description (new Lister ().Strict (true).Indent_Arrays (false))");
	System.out.println (parameters.Description
		(new Lister ().Strict (true).Indent_Arrays (false)));

	System.out.println
		("--- Checking the aggregate list:\n"
		+ "\tIs_Parameter_List (parameters.List ())");
	//	Is_Parameter_List: List
	if (! Parameter.Is_Parameter_List (parameters.List ()))
		{
		System.out.println ("!!! Does not have a valid aggregate list.");
		System.exit (1);
		}
	else
		System.out.println ("*** Correct");

	System.out.println
		("--- Writing the parameters:\n"
		+ "\tparameters.Write ();");
	//	Write:
	count = parameters.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Creating a File for the parameters:\n"
		+ "\tfile = new File (\"/tmp/PVL.test\");");
	File
		file = new File ("/tmp/PVL.test");
	//	Write: File
	System.out.println
		("--- Writing the parameters to the File:\n"
		+ "\tparameters.Write (new FileOutputStream (file));");
	parameters.Write (new FileOutputStream (file));

	System.out.println
		("--- Constructing a param from the File:\n"
		+ "\tparam = new Parameter (\"File:PVL.test\", new Parser (file));");
	//	Constructor: File Parser
	param = new Parameter ("File:PVL.test", new Parser (file));
	if (param.Warning () != null)
		{
		System.out.println (param.Warning ().getMessage ());
		System.out.println ("!!! Aggregate enclosure mismatch not fixed.");
		}
	else
		System.out.println ("*** Aggregate enclosure mismatch fixed.");
	file.delete ();
	System.out.println ("--- param.Write ();");
	count = param.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Getting \"PVL.test\" from \"File:PVL.test\":\n"
		+ "\tparam = param.Remove (param.Find (\"PVL.test\"));");
	//	Find: String
	new_param = param.Find ("PVL.test");
	if (new_param == null)
		{
		System.out.println ("!!! Find Failed!");
		System.exit (1);
		}
	//	Remove: Parameter
	param = param.Remove (new_param);
	if (param == null)
		{
		System.out.println ("!!! Remove Failed!");
		System.exit (1);
		}

	System.out.println
		("--- Testing equality of parameters and param:\n"
		+ "\tparameters.equals (param)");
	//	equals:
	if (parameters.equals (param))
		System.out.println ("*** true");
	else
		System.out.println ("!!! false");

	System.out.println
		("--- Constructing a param from the parameters:\n"
		+ "\tparam = new Parameter (parameters);");
	//	Constructor: Parameter copy
	param = new Parameter (parameters);
	System.out.println ("--- param.Write ();");
	count = param.Write ();
	System.out.println ("--- parameters.Write ();");
	count = parameters.Write ();

	System.out.println
		("--- Testing equivalence of parameters and param:\n"
		+ "\tparameters.equalsIgnoreCase (param)");
	//	equalsIgnoreCase:
	if (parameters.equalsIgnoreCase (param))
		System.out.println ("*** true");
	else
		System.out.println ("!!! false");

	//	toString:
	System.out.println ("--- Iterating through " + parameters);
	print_params (parameters);

	System.out.println
		("--- Finding \"SUB_A2\":\n"
		+ "\tparam = parameters.Find (\"SUB_A2\");");
	//	Find: Name
	param = parameters.Find ("SUB_A2");
	if (param == null)
		{
		System.out.println ("!!! Not found");
		System.exit (1);
		}

	//	Classification_Name:
	//	Path_Name:
	System.out.println ("*** Found: "
		+ param.Classification_Name () + " " + param.Path_Name ());
	System.out.println
		("--- Setting to END_AGGREGATE:\n"
		+ "\tparam_class = param.Classification ();\n"
		+ "\tparam.Classification (Parameter.END_AGGREGATE);");
	//	Classification: END_AGGREGATE
	param_class = param.Classification ();
	param.Classification (Parameter.END_AGGREGATE);
	System.out.println (param.Classification_Name () + " " + param.Path_Name ());
	parameters.Write ();

	System.out.println
		("\n--- Finding \"SUB_A3\":\n"
		+ "\tparameters.Find (\"SUB_A3\")");
	//	Find: past END_AGGREGATE
	if (parameters.Find ("SUB_A3") == null)
		System.out.println ("*** Not found (correct)");
	else
		System.out.println ("!!! Found (shouldn't have)");
	//	Parent:
	System.out.println
		("--- Iterating through " + param.Parent ().Name ());
	print_params (param.Parent ());
	System.out.println ("--- Writing everything");
	count = parameters.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Restoring the previous classification:\n"
		+ "\tparam.Classification (param_class);");
	//	Classification: restore list
	param.Classification (param_class);
	param.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Finding the previously found parameter:\n"
		+ "\tparam = parameters.Find (param);");
	//	Find: Parameter
	param = parameters.Find (param);
	if (param == null)
		{
		System.out.println ("!!! Not found");
		System.exit (1);
		}
	System.out.println ("*** Found");
	System.out.println
		("--- Iterating through " + param.Parent ().Name ());
	print_params (param.Parent ());
	System.out.println ("--- Writing everything");
	count = parameters.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Finding \"TOP_1\":\n"
		+ "\tparam = parameters.Find (\"TOP_1\", Parameter.AGGREGATE);");
	//	Find: Name and Classification
	param = parameters.Find ("TOP_1", Parameter.AGGREGATE);
	if (new_param == null)
		{
		System.out.println ("!!! Not found");
		System.exit (1);
		}
	if (! new_param.Is_Aggregate ())
		{
		System.out.println ("!!! Found Assignment: " + param.Path_Name ());
		System.exit (1);
		}
	System.out.println ("*** Found");

	System.out.println
		("--- Finding parameter with Value 2.0:\n"
		+ "\tparam = parameters.Find\n"
		+ "\t	(\n"
		+ "\t	new Parameter ().Value (2.0),\n"
		+ "\t	new Selection ()\n"
		+ "\t		.Value (true)\n"
		+ "\t		.Data (true)\n"
		+ "\t	);");
	//	Value: Real
	//	Selection: Value Data
	//	Find: Value
	param = parameters.Find
		(
		new Parameter ().Value (2.0),
		new Selection ()
			.Value (true)
			.Data (true)
		);
	if (param == null)
		{
		System.out.println ("!!! Not found");
		System.exit (1);
		}
	//	Path_to_Name:
	System.out.print ("*** Found: " + param.Path_to_Name ());
	param.Write ();

	System.out.println
		("--- Setting to END_PVL:\n"
		+ "\tparam_class = param.Classification ();\n"
		+ "\tparam.Classification (Parameter.END_PVL);");
	//	Classification: END_PVL
	param_class = param.Classification ();
	param.Classification (Parameter.END_PVL);
	System.out.println
		("--- Iterating through " + param.Parent ().Name ());
	print_params (param.Parent ());
	System.out.println ("--- Writing everything");
	count = parameters.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Constructing a param from the parameters:\n"
		+ "\tparam = new Parameter (parameters);");
	//	Constructor: Parameter copy
	param = new Parameter (parameters);
	System.out.println ("--- param.Write ();");
	count = param.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Testing equivalence of parameters and param:\n"
		+ "\tparameters.equalsIgnoreCase (param)");
	//	equalsIgnoreCase:
	if (parameters.equalsIgnoreCase (param))
		System.out.println ("*** true");
	else
		System.out.println ("!!! false");
	System.out.println
		("--- Testing equality of parameters and param:\n"
		+ "\tparameters.equals (param)");
	//	equals:
	if (parameters.equals (param))
		System.out.println ("!!! true; but not identical");
	else
		System.out.println ("*** false; not identical (correct)");

	System.out.println
		("--- Finding the END_PVL parameter:\n"
		+ "\tparam = parameters.Find (Parameter.END_PVL);");
	//	Find: Classification
	param = parameters.Find (Parameter.END_PVL);
	if (param == null)
		{
		System.out.println ("!!! Not found");
		System.exit (1);
		}
	System.out.println
		("*** Found");
	System.out.println
		("--- Restoring the previous classification:\n"
		+ "\tparam.Classification (param_class);");
	//	Classification: restore list
	param.Classification (param_class);
	System.out.println
		("--- Iterating through " + param.Parent ().Name ());
	print_params (param.Parent ());
	System.out.println ("--- Writing everything");
	count = parameters.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Try iterating on an ASSIGNMENT (should show nothing): "
		+ param.Classification_Name () + " " + param);
	print_params (param);
	System.out.println ("---");

	System.out.println
		("--- New TEXT Value parameter:\n"
		+ "\tnew_param = new Parameter (\"New\").Value (\"'This is a new parameter'\");");
	//	Value: String TEXT
	new_param = new Parameter ("New").Value ("\"This is a new parameter\"");
	new_param.Write ();

	System.out.println
		("--- Add it to a token parameter:\n"
		+ "\tparam = new Parameter(\"Test\").Add (new_param);");
	//	Add: Assignment to Token
	param = new Parameter("Test").Add (new_param);
	param.Write ();
	System.out.println
		("--- Change \"Test\" back to a token:\n"
		+ "\tparam.Classification (Parameter.TOKEN);");
	//	Classification: Aggregate to Token
	param.Classification (Parameter.TOKEN);
	param.Write ();

	System.out.println
		("--- Add the \"PVL.test\" parameters to the \"New\" parameter:\n"
		+ "\tnew_param.Add (parameters);");
	//	Add: Aggregate to Assignment
	test = true;
	try {new_param.Add (parameters);}
	catch (PVL_Exception exception)
		{
		System.out.println (exception.getMessage () + "\n");
		System.out.println ("*** Correct");
		test = false;
		}
	if (test)
		{
		System.out.println ("!!! Wrong: should have failed.");
		System.exit (1);
		}
	System.out.println
		("--- Add the \"New\" parameter to the \"PVL.test\" parameters:\n"
		+ "\tparameters.Add (new_param);");
	//	Add: Assignment to Aggregate
	parameters.Add (new_param);
	print_params (parameters);
	System.out.println
		("--- Remove it:\n"
		+ "\tparameters.Remove (new_param);");
	//	Remove: Parameter
	parameters.Remove (new_param);
	print_params (parameters);
	System.out.println
		("--- Try to Add a Vector containing a String:\n"
		+ "\tparameters.Add (vector);");
	Vector vector = new Vector ();
	vector.add (new String ("A String"));
	//	Add: String Vector to Aggregate
	test = true;
	try {parameters.Add (vector);}
	catch (PVL_Exception exception)
		{
		System.out.println (exception.getMessage () + "\n");
		System.out.println ("*** Correct");
		test = false;
		}
	if (test)
		{
		System.out.println ("!!! Wrong: should have failed.");
		System.exit (1);
		}

	System.out.println
		("--- ListIterator starting at second entry:\n"
		+ "\tlist = parameters.listIterator (1);");
	//	ListIterator:
	ListIterator
		list = parameters.listIterator (1);
	System.out.println
		("--- Iterating forward:\n"
		+ "\twhile (list.hasNext ()) {\n"
		+ "\t	list.next ();");
	//	ListIterator: hasNext
	while (list.hasNext ())
		{
		//	ListIterator: next
		param = (Parameter)list.next ();
		System.out.println
			(param.Classification_Name () + ": " + param.Name ());
		if (param.Name ().equals ("SUB_A"))
			{
			System.out.println
				("--- add \"New\" parameter after \"SUB_A\":\n"
				+ "\tlist.add (new_param);");
			//	ListIterator: add
			list.add (new_param);
			}
		}
	System.out.println
		("--- Iterating back:\n"
		+ "\twhile (list.hasPrevious ()) {\n"
		+ "\t	list.previous ();");
	//	ListIterator: hasPrevious
	while (list.hasPrevious ())
		{
		//	ListIterator: previous
		param = (Parameter)list.previous ();
		System.out.println
			(param.Classification_Name () + ": " + param.Name ());
		}

	System.out.println
		("--- Iterating foward again");
		while (list.hasNext ())
		{
		param = (Parameter)list.next ();
		System.out.println
			(param.Classification_Name () + ": " + param.Name ());
		if (param.Name ().equals ("New"))
			{
			System.out.println
				("--- remove \"New\" parameter:\n"
				+ "\tlist.remove ();");
			//	ListIterator: remove
			list.remove ();
			}
		}
	System.out.println ("--- Writing everything");
	count = parameters.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Iterating back again");
	while (list.hasPrevious ())
		{
		param = (Parameter)list.previous ();
		System.out.println
			(param.Classification_Name () + ": " + param.Name ());
		if (param.Name ().equals ("SUB_A"))
			{
			System.out.println
				("--- Replace \"SUB_A\" with \"New\" parameter:\n"
				+ "\tlist.set (new_param);");
			//	ListIterator: set
			list.set (new_param);
			break;
			}
		}
	System.out.println ("--- Writing everything");
	count = parameters.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Insert \"SUB_A\" at the third entry:\n"
		+ "\tparameters.Insert (param:\"SUB_A\", 2);");
	//	Insert:
	parameters.Insert (param, 2);
	count = parameters.Write ();
	System.out.println (count + " characters written.\n");

	System.out.println
		("--- Write to a Byte Array:\n"
		+ "\tparameters.Write (ByteArrayOutputStream);");
	ByteArrayOutputStream
		description = new ByteArrayOutputStream ();
	//	Write: to ByteArrayOutputStream
	count = parameters.Write (description);
	System.out.println (description);
	System.out.println (count + " characters written.\n");


	}
catch (Exception exception)
	{
	exception.printStackTrace (System.out);
	System.out.println ("!!! Fatal flaw: FIX IT\n");
	System.exit (-1);
	}
System.exit (0);
}


public static void print_params (Parameter parameter)
{
//	Iterator:
Iterator
	list = parameter.iterator ();
while (list.hasNext ())
	{
	Parameter
		param = (Parameter)list.next ();
	System.out.println
		(param.Classification_Name () + ": " + param.Name ());
	}
//	Test for END_PVL.
try {list.next ();}
catch (NoSuchElementException exception)
	{
	if (exception.getMessage ()
			.startsWith (Parameter.Classification_Name (Parameter.END_PVL)))
		System.out.println ("~~~ " + exception.getMessage ());
	}
}


}
