/* Generated from "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod" by precompile.pike running Pike v7.8 release 700
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 3

#undef PRECOMPILE_SUB_PIKEVARS
#define PRECOMPILE_SUB_PIKEVARS 1

#undef PRECOMPILE_DYNAMIC_TYPES
#define PRECOMPILE_DYNAMIC_TYPES 1


#line 1 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
*/

#include "global.h"
#include "gmp_machine.h"

#if defined(HAVE_GMP2_GMP_H) && defined(HAVE_LIBGMP2)
#define USE_GMP2
#else /* !HAVE_GMP2_GMP_H || !HAVE_LIBGMP2 */
#if defined(HAVE_GMP_H) && defined(HAVE_LIBGMP)
#define USE_GMP
#endif /* HAVE_GMP_H && HAVE_LIBGMP */
#endif /* HAVE_GMP2_GMP_H && HAVE_LIBGMP2 */

#if defined(USE_GMP) || defined(USE_GMP2)

#include "my_gmp.h"

#include "interpret.h"
#include "svalue.h"
#include "stralloc.h"
#include "array.h"
#include "pike_macros.h"
#include "program.h"
#include "stralloc.h"
#include "object.h"
#include "pike_types.h"
#include "pike_error.h"
#include "builtin_functions.h"
#include "module_support.h"
#include "bignum.h"
#include "operators.h"
#include "mapping.h"
#include "gc.h"
#include "pike_types.h"

#include <limits.h>
#include <math.h>


#define sp Pike_sp
#define fp Pike_fp

#define DEFAULT_CMOD_STORAGE



#ifndef PIKE_UNUSED_ATTRIBUTE
#define PIKE_UNUSED_ATTRIBUTE
#endif
#define CMOD_MAP_PROGRAM_IDS_DEFINED 1
static int ___cmod_map_program_ids(int id) PIKE_UNUSED_ATTRIBUTE;
#ifndef TYPEOF
/* Compat with older Pikes. */
#define TYPEOF(SVAL)	((SVAL).type)
#define SUBTYPEOF(SVAL)	((SVAL).subtype)
#define SET_SVAL_TYPE(SVAL, TYPE)	(TYPEOF(SVAL) = TYPE)
#define SET_SVAL_SUBTYPE(SVAL, TYPE)	(SUBTYPEOF(SVAL) = TYPE)
#define SET_SVAL(SVAL, TYPE, SUBTYPE, FIELD, EXPR) do {	\
    /* Set the type afterwards to avoid a clobbered	\
     * svalue in case EXPR throws. */			\
    (SVAL).u.FIELD = (EXPR);				\
    SET_SVAL_TYPE((SVAL), (TYPE));			\
    SET_SVAL_SUBTYPE((SVAL), (SUBTYPE));		\
  } while(0)
#endif /* !TYPEOF */
#ifndef PIKE_UNUSED
/* Compat with Pike 7.8 and earlier. */
/* NB: Not strictly correct; PIKE_UNUSED was added the
 *     day after set_program_id_to_id(), but good enough.
 */
#ifndef UNUSED
#define UNUSED(X)	X
#endif
#ifndef set_program_id_to_id
/* NB: Recent Pike 7.8 has a #define that conflicts with
 *     the following declaration.
 */
static void set_program_id_to_id(void*UNUSED(id)){}
#endif
#else /* */
PMOD_EXPORT void set_program_id_to_id( int (*to)(int) );
#endif /* !PIKE_UNUSED */


#ifndef DEFAULT_CMOD_STORAGE
#define CMOD_COND_USED
#define DEFAULT_CMOD_STORAGE static
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__sprintf_fun_num_used 1
#else
#undef f_mpq_cq__sprintf_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq___hash_fun_num_used 1
#else
#undef f_mpq_cq___hash_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_get_string_fun_num_used 1
#else
#undef f_mpq_get_string_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__is_type_fun_num_used 1
#else
#undef f_mpq_cq__is_type_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_21_fun_num_used 1
#else
#undef f_mpq_cq__backtick_21_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_backtick_25_fun_num_used 1
#else
#undef f_mpq_cq__backtick_backtick_25_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_backtick_2F_fun_num_used 1
#else
#undef f_mpq_cq__backtick_backtick_2F_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cast_fun_num_used 1
#else
#undef f_mpq_cast_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_2D_fun_num_used 1
#else
#undef f_mpq_cq__backtick_2D_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_2A_fun_num_used 1
#else
#undef f_mpq_cq__backtick_2A_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_backtick_2A_fun_num_used 1
#else
#undef f_mpq_cq__backtick_backtick_2A_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_25_fun_num_used 1
#else
#undef f_mpq_cq__backtick_25_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_sgn_fun_num_used 1
#else
#undef f_mpq_sgn_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_2F_fun_num_used 1
#else
#undef f_mpq_cq__backtick_2F_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_invert_fun_num_used 1
#else
#undef f_mpq_invert_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_add_eq_fun_num_used 1
#else
#undef f_mpq_cq__backtick_add_eq_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_get_int_fun_num_used 1
#else
#undef f_mpq_get_int_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_add_fun_num_used 1
#else
#undef f_mpq_cq__backtick_add_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_create_fun_num_used 1
#else
#undef f_mpq_create_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_num_fun_num_used 1
#else
#undef f_mpq_num_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_den_fun_num_used 1
#else
#undef f_mpq_den_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_7E_fun_num_used 1
#else
#undef f_mpq_cq__backtick_7E_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_eq_eq_fun_num_used 1
#else
#undef f_mpq_cq__backtick_eq_eq_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_backtick_2D_fun_num_used 1
#else
#undef f_mpq_cq__backtick_backtick_2D_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_backtick_add_fun_num_used 1
#else
#undef f_mpq_cq__backtick_backtick_add_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define mpq_program_fun_num_used 1
#else
#undef mpq_program_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_get_float_fun_num_used 1
#else
#undef f_mpq_get_float_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_3E_fun_num_used 1
#else
#undef f_mpq_cq__backtick_3E_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_mpq_cq__backtick_3C_fun_num_used 1
#else
#undef f_mpq_cq__backtick_3C_fun_num_used
#endif
#line 51 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
#define THISMPQ (&(THIS->n))

/*! @module Gmp
 */

/*! @class mpq
 *! Rational number stored in canonical form. The canonical from means
 *! that the denominator and the numerator have no common factors, and
 *! that the denominator is positive. Zero has the unique
 *! representation 0/1. All functions canonicalize their result.
 */

/*  id PROG_GMP_MPQ_ID; */

#undef class_mpq_defined
#define class_mpq_defined
DEFAULT_CMOD_STORAGE struct program *mpq_program=NULL;

#ifdef mpq_program_fun_num_used
DEFAULT_CMOD_STORAGE int mpq_program_fun_num=-1;
#endif /* mpq_program_fun_num_used */

#undef var_n_mpq_defined
#define var_n_mpq_defined

#undef THIS
#define THIS ((struct mpq_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MPQ
#define THIS_MPQ ((struct mpq_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MPQ
#define OBJ2_MPQ(o) ((struct mpq_struct *)(o->storage+mpq_storage_offset))

#undef GET_MPQ_STORAGE
#define GET_MPQ_STORAGE(o) ((struct mpq_struct *)(o->storage+mpq_storage_offset)
static ptrdiff_t mpq_storage_offset;
struct mpq_struct {

#ifdef var_n_mpq_defined
#line 66 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
MP_RAT n;
#endif /* var_n_mpq_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct mpq_struct *mpq_gdb_dummy_ptr;
#endif
#line 68 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
static void get_mpq_from_digits(MP_RAT *tmp,
				  struct pike_string *digits,
				  int base)
    {
      p_wchar0 *str;
  
      if(digits->size_shift)
	Pike_error("Illegal characters, cannot convert to mpq.\n");
      str=STR0(digits);

      /* Huh, wot? /mast
      get_mpz_from_digits(mpq_numref(tmp), digits, base);
      */
      
      if(!base || ((base >= 2) && (base <= 36)))
      {
	int offset = 0;
	int neg = 0;
	int dotfound = 0;
	
	if(digits->len > 1)
	{
	  if(str[0] == '+')
	    offset ++;
	  else if(str[0] == '-')
	  {
	    offset ++;
	    neg = 1;
	  }
	  
	  /* We need to fix the case with binary
	     0b101... and -0b101... numbers. */
	  if(!base && digits->len > 2)
	  {
	    if(str[offset] == '0')
	    {
	      switch(str[offset+1])
	      {
		case 'b':
		case 'B':
		  offset+=2;
		  base=2;
		  break;
		  
		case '0':
		  offset+=2;
		  base=8;
		  break;
		  
		case 'x':
		  offset+=2;
		  base=16;
		  break;
	      }
	    }
	  }
	}

	if(!base) base=10;
	
	mpq_set_ui(tmp, 0, 1);
	while(str[offset])
	{
	  int x=255;
	  if(str[offset] == '.')
	  {
	    offset++;
	    if(dotfound)
	      Pike_error("Invalid digits, cannot convert to mpq.\n");
	    dotfound++;
	    continue;
	  }
	  
	  if(str[offset] >= '0' && str[offset] <= '9')
	    x=str[offset]-'0';
	  else if(str[offset] >='a' && str[offset] <= 'z')
	    x=str[offset]-'a';
	  else if(str[offset] >='A' && str[offset] <= 'Z')
	    x=str[offset]-'A';
	  
	  if(x > base)
	    Pike_error("Invalid digits, cannot convert to mpq.\n");
	  
	  mpz_mul_ui(mpq_numref(tmp),
		     mpq_numref(tmp),
		     base);
	  if(dotfound)
	  {
	    mpz_mul_ui(mpq_denref(tmp),
		       mpq_denref(tmp),
		       base);
	  }
	  mpz_add_ui(mpq_numref(tmp),
		     mpq_numref(tmp),
		     x);
	  offset++;
	}

	if(dotfound)
	  mpq_canonicalize(tmp);

	if(neg)
	  mpz_neg(mpq_numref(tmp), mpq_numref(tmp));
      }
      else if(base == 256)
      {
	mpq_set_ui(tmp, 1, 1);
	get_mpz_from_digits(mpq_numref(tmp), digits, base);
      }
      else
      {
	Pike_error("invalid base.\n");
      }
    }

  int get_new_mpq(MP_RAT *tmp, struct svalue *s,
		  int throw_error, const char *arg_func, int arg, int args)
    {
      switch(TYPEOF(*s))
      {
	case T_FLOAT:
	{
	  double t;
	  int y;
	  t=frexp((double) s->u.float_number, &y);

	  t*=pow(2.0,48.0);
	  y-=48;

	  mpz_set_d(mpq_numref(tmp), t);
	  mpz_set_ui(mpq_denref(tmp), 1);
	  if(y>0)
	    mpz_mul_2exp(mpq_numref(tmp),mpq_numref(tmp),y);
	  else if(y<0)
	    mpz_mul_2exp(mpq_denref(tmp),mpq_denref(tmp),-y);

	  mpq_canonicalize(tmp);
	  break;
	}
	  
	case T_INT:
	  get_new_mpz(mpq_numref(tmp), s, 1, arg_func, arg, args);
	  mpz_set_si(mpq_denref(tmp),1);
	  break;
	  
	case T_OBJECT:
	  if(IS_MPZ_OBJ (s->u.object))
	  {
	    mpq_set_z(tmp, OBTOMPZ(s->u.object));
	    break;
	  }
	  
	  if(s->u.object->prog == mpq_program)
	  {
	    mpq_set(tmp, OBTOMPQ(s->u.object));
	    break;
	  }
	  
	  if (s->u.object->prog) {
	    if (throw_error)
	      SIMPLE_ARG_TYPE_ERROR (arg_func, arg, "int|float|Gmp.mpq|Gmp.mpz");
	    else
	      return 0;
	  } else {
	    /* Destructed object. Use as zero. */
	    mpq_set_si(tmp, 0, 1);
	  }
	  break;
	  
	default:
	  if (throw_error)
	    SIMPLE_ARG_TYPE_ERROR (arg_func, arg, "int|float|Gmp.mpq|Gmp.mpz");
	  else
	    return 0;
      }

      return 1;
    }

/* Converts an svalue, located on the stack, to an mpq object */
  static MP_RAT *debug_get_mpq(struct svalue *s,
			       int throw_error, const char *arg_func, int arg, int args)
  {
    struct object *o = fast_clone_object (mpq_program);
    ONERROR uwp;
    SET_ONERROR (uwp, do_free_object, o);
    if (get_new_mpq (OBTOMPQ (o), s, throw_error, arg_func, arg, args)) {
      UNSET_ONERROR (uwp);
      free_svalue(s);
      SET_SVAL(*s, T_OBJECT, 0, object, o);
      return OBTOMPQ (o);
    }
    else {
      UNSET_ONERROR (uwp);
      free_object (o);
      return NULL;
    }
  }

#ifdef DEBUG_MALLOC
#define get_mpq(S, THROW_ERROR, ARG_FUNC, ARG, ARGS)			\
  (REFCOUNTED_TYPE(TYPEOF(*(S))) ? debug_malloc_touch((S)->u.object) : 0, \
   debug_get_mpq((S), (THROW_ERROR), (ARG_FUNC), (ARG), (ARGS)))
#else
#define get_mpq debug_get_mpq
#endif

  /*! @decl protected void create(void|string|int|float|Gmp.mpz|Gmp.mpq x)
   *! @decl protected void create(int numerator, int denominator)
   *! @decl protected void create(string x, int base)
   */
  #define f_mpq_create_defined

#ifdef f_mpq_create_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_create_fun_num = 0;

#endif /* f_mpq_create_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_create(INT32 args) {
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct svalue * x;
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct svalue * base;
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if ((args > 0) &&
    ((TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[0-args]) != NUMBER_UNDEFINED))) {
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
x=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
} else x = NULL;
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if ((args > 1) &&
    ((TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[1-args]) != NUMBER_UNDEFINED))) {
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",2,"void|int");
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
base=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
} else base = NULL;
#line 282 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
    switch(args)
    {
      case 2:
	/* Args are string of digits and integer base */
	/* or int num / den */

	if (base && x) {
	  if (TYPEOF(*base) != T_INT)
	    if(TYPEOF(*base) != T_OBJECT ||
	     base->u.object->prog != bignum_program ||
	       TYPEOF(*x) == T_STRING)
	      SIMPLE_ARG_TYPE_ERROR ("create", 2, "int");

	  switch(TYPEOF(*x))
	  {
	  case T_STRING:
	    get_mpq_from_digits(THISMPQ, x->u.string, base->u.integer);
	    break;

	  case T_OBJECT:
	    if(x->u.object->prog != bignum_program)

	  default:
	      SIMPLE_ARG_TYPE_ERROR ("create", 1, "int|string");

	  case T_INT:
	    mpq_set_num(THISMPQ,get_mpz(x, 1, "create", 1, args));
	    mpq_set_den(THISMPQ,get_mpz(base, 1, "create", 2, args));
	    mpq_canonicalize(THISMPQ);
	    break;
	  }
	  break;
	}
	/* FALL_THROUGH */

      case 1:
	if (x) {
	  if(TYPEOF(*x) == T_STRING)
	    get_mpq_from_digits(THISMPQ, x->u.string, 0);
	  else
	    get_new_mpq(THISMPQ, x, 1, "create", 1, args);
	  break;
	}
	/* FALL_THROUGH */

      case 0:
	break;

      default:
	SIMPLE_WRONG_NUM_ARGS_ERROR ("create", 2);
    }
  }

  }
/*! @decl int get_int()
   */
  #define f_mpq_get_int_defined

#ifdef f_mpq_get_int_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_get_int_fun_num = 0;

#endif /* f_mpq_get_int_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_get_int(INT32 args) {
#line 338 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("get_int",args,0);
{
      struct object *res = fast_clone_object(mpzmod_program);
      mpz_tdiv_q(OBTOMPZ(res), mpq_numref(THISMPQ), mpq_denref(THISMPQ));
      /* FIXME */
      mpzmod_reduce(res);
    }

  }
/*! @decl protected int __hash()
   */
  #define f_mpq_cq___hash_defined

#ifdef f_mpq_cq___hash_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq___hash_fun_num = 0;

#endif /* f_mpq_cq___hash_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq___hash(INT32 args) {
#line 348 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("__hash",args,0);
#line 350 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(
#line 352 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
mpz_get_si(mpq_numref(THISMPQ)) * 1000003 +
	mpz_get_si(mpq_denref(THISMPQ)));  push_int(ret_); return; }while(0);
#line 354 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl float get_float()
   */
  #define f_mpq_get_float_defined

#ifdef f_mpq_get_float_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_get_float_fun_num = 0;

#endif /* f_mpq_get_float_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_get_float(INT32 args) {
#line 358 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("get_float",args,0);
{
      do { FLOAT_TYPE ret_=((FLOAT_TYPE) mpq_get_d(THISMPQ));  push_float(ret_); return; }while(0);
#line 361 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
#line 363 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
static void format_dec_frac (mpz_t num, int prec)
  {
    struct pike_string *s;
    ptrdiff_t len = mpz_sizeinbase (num, 10);

    assert (prec);

    if (len > prec) {
      /* one for the dot... */
      prec++;
      /* present 'num' and insert dot */
      len += 3;
      s = begin_shared_string(len);
      if(len/2 > prec)
      {
	/* Shift the integer part forward to make room for the dot. */
	mpz_get_str(s->str+1, 10, num);
	/* Find NULL character */
	len-=4;
	if (len < 1) len = 1;
	while(s->str[len]) len++;
	memmove(s->str, s->str+1, len-prec);
      }else{
	/* Shift the fractional part backward to make room for the dot. */
	mpz_get_str(s->str, 10, num);
	/* Find NULL character */
	len-=5;
	if (len < 0) len = 0;
	while(s->str[len]) len++;
	memmove(s->str+len-prec+1,
		s->str+len-prec,
		prec+1);
	len++;
      }
      s->str[len-prec]='.';
      push_string (end_and_resize_shared_string (s, len));
    }

    else {
      /* The precision is greater than the length, so start out
       * with a string of zeroes. */
      char *p;
      s = begin_shared_string (prec + 4);
      p = s->str;
      if (mpz_sgn (num) < 0) {
	*p++ = '-';
	mpz_neg (num, num);
      }
      *p++ = '0';
      *p++ = '.';
      for (; prec > len; prec--) *p++ = '0';
      mpz_get_str (p, 10, num);
      if (!p[len - 1]) {
	memmove (p + 1, p, len - 1);
	*p = '0';
      }
      push_string (end_and_resize_shared_string (s, p - s->str + len));
    }
  }

  static void format_string (mpq_t mpq, int dec_fract)
  {
    if (dec_fract >= 1) {
      mpz_t den, f;
      size_t strings = 0, twos, fives, prec;

      /* Remove from the denominator all factors 2 and 5, which are
       * the only ones we can compensate for with a decimal
       * fraction. */
      mpz_init_set (den, mpq_denref (mpq));
      mpz_init_set_ui (f, 2u);
      twos = mpz_remove (den, den, f);
      mpz_set_ui (f, 5u);
      fives = mpz_remove (den, den, f);

      /* The necessary number of decimals is the same as the number of
       * times we have to multiply by 10 to get an integer (if the
       * denominator only contains factors 2 and 5). Since we
       * "consume" one factor 2 and one factor 5 every time, that
       * means we need the same number of 10's as the max of the 2's
       * and 5's. */
      prec = MAXIMUM (twos, fives);

      if (prec) {
	mpz_t num;
	mpz_init (num);
	mpz_ui_pow_ui (num, 10, prec);
	mpz_mul (num, num, mpq_numref (mpq));
	if (twos)
	  mpz_tdiv_q_2exp (num, num, twos);
	if (fives) {
	  mpz_pow_ui (f, f, fives);
#ifdef HAVE_MPZ_DIVISIBLE_P
	  assert (mpz_divisible_p (num, f));
#endif
	  mpz_tdiv_q (num, num, f);
	}
	format_dec_frac (num, prec);
	strings++;
	mpz_clear (num);
      }
      else {
	push_string (low_get_mpz_digits (mpq_numref (mpq), 10));
	strings++;
	if (dec_fract >= 2) {
	  push_constant_text (".0");
	  strings++;
	}
      }

      /* If the denominator contains other factors we still need to
       * display it. */
      if (mpz_cmp_ui (den, 1u)) {
	push_text ("/");
	push_string (low_get_mpz_digits (den, 10));
	strings += 2;
      }

      mpz_clear (den);
      mpz_clear (f);
      if (strings > 1) f_add (strings);
    }

    else {
      push_string(low_get_mpz_digits(mpq_numref(mpq),10));
      push_text("/");
      push_string(low_get_mpz_digits(mpq_denref(mpq),10));
      f_add(3);
    }
  }

  /*! @decl string get_string (void|int decimal_fraction)
   *!
   *! If @[decimal_fraction] is zero or left out, the number is
   *! returned as a string on the form @expr{"numerator/denominator"@},
   *! where both parts are decimal integers. The numerator may be
   *! negative, but the denominator is always positive.
   *!
   *! If @[decimal_fraction] is set, then the number is returned as a
   *! (possibly negative) decimal fraction, i.e. a decimal number with
   *! a decimal point somewhere inside. There is always at least one
   *! digit before and after the decimal point.
   *!
   *! If the number can be accurately described that way, i.e. without
   *! an infinite number of decimals, then no denominator is included.
   *! Otherwise the remaining denominator is added to the decimal
   *! fraction after a "/". For example, 4711/100 is returned as
   *! @expr{"47.11"@}, 4711/200 as @expr{"23.555"@}, and 4711/300 as
   *! @expr{"47.11/3"@}.
   *!
   *! If @[decimal_fraction] is 1 then the decimal fraction contains a
   *! '.' only if there are decimals in it. If it is 2 or higher then
   *! the decimal fraction always contains a '.' with at least one
   *! digit before and after it.
   *!
   *! @note
   *! In any case, there are no unnecessary padding zeroes at the
   *! beginning or end of any decimal number.
   */
  #define f_mpq_get_string_defined

#ifdef f_mpq_get_string_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_get_string_fun_num = 0;

#endif /* f_mpq_get_string_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_get_string(INT32 args) {
#line 522 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
INT_TYPE decimal_fraction;
#line 522 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args > 1) wrong_number_of_args_error("get_string",args,1);
#line 522 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if ((args > 0) &&
    ((TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[0-args]) != NUMBER_UNDEFINED))) {
#line 522 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("get_string",1,"void|int");
#line 522 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
decimal_fraction=Pike_sp[0-args].u.integer;
#line 522 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
} else decimal_fraction = 0;
{
    format_string (THISMPQ, decimal_fraction);
  }

  }
/*! @decl int num()
   *!
   *! Returns the numerator.
   */
  #define f_mpq_num_defined

#ifdef f_mpq_num_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_num_fun_num = 0;

#endif /* f_mpq_num_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_num(INT32 args) {
#line 531 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("num",args,0);
{
    push_object (fast_clone_object (bignum_program));
    mpz_set (OBTOMPZ (sp[-1].u.object), mpq_numref (THISMPQ));
    reduce_stack_top_bignum();
  }

  }
/*! @decl int den()
   *!
   *! Returns the denominator. It is always positive.
   */
  #define f_mpq_den_defined

#ifdef f_mpq_den_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_den_fun_num = 0;

#endif /* f_mpq_den_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_den(INT32 args) {
#line 542 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("den",args,0);
{
    push_object (fast_clone_object (bignum_program));
    mpz_set (OBTOMPZ (sp[-1].u.object), mpq_denref (THISMPQ));
    reduce_stack_top_bignum();
  }

  }
#line 549 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
static int lookup(const char *name,
		    struct mapping *m,
		    char *ind,
		    int def,
		    int arg, int args)
    {
      struct svalue *sv;
      if((sv=simple_mapping_string_lookup(m,ind)))
      {
	if(TYPEOF(*sv) == T_INT)
	{
	  return sv->u.integer;
	}else{
	  bad_arg_error (name, Pike_sp - args, args, arg, NULL, Pike_sp + arg - 1 - args,
			 "Bad argument %d to %s(). "
			 "The field \"%s\" doesn't hold an integer.\n",
			 arg, name, ind);
	}
      }
      return def;
    }
		    
  /*! @decl protected string _sprintf(int c, mapping flags)
   */
  #define f_mpq_cq__sprintf_defined

#ifdef f_mpq_cq__sprintf_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__sprintf_fun_num = 0;

#endif /* f_mpq_cq__sprintf_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__sprintf(INT32 args) {
#line 573 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
INT_TYPE c;
#line 573 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct mapping * flags;
#line 573 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 573 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(TYPEOF(Pike_sp[0-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("_sprintf",1,"int");
#line 573 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
c=Pike_sp[0-2].u.integer;
#line 573 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(TYPEOF(Pike_sp[1-2]) != PIKE_T_MAPPING) SIMPLE_ARG_TYPE_ERROR("_sprintf",2,"mapping(mixed:mixed)");
#line 573 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
debug_malloc_pass(flags=Pike_sp[1-2].u.mapping);
#line 575 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
        INT_TYPE precision;

      precision=lookup("Gmp.Mpq->_sprintf",flags,"precision",7, 2, args);
      pop_n_elems(args);
      if(precision<0) precision=0;

      switch(c)
      {
	default:
	  push_undefined();
	  return;

	case 'O':
	  push_text ("Gmp.mpq(");
	  format_string (THISMPQ, 1);
	  push_text (")");
	  f_add (3);
	  return;

	  /* Fixme: Support g/e/E */
	case 'g':
	case 'e':
	case 'E':
	case 'f':
	{
	  mpz_t tmp;

	  mpz_init(tmp);
	  mpz_ui_pow_ui(tmp, 10, precision);
	  mpz_mul(tmp, tmp, mpq_numref(THISMPQ));
	  mpz_tdiv_q(tmp, tmp, mpq_denref(THISMPQ));

	  if (!precision)
	    /* No dot if the precision is zero. This is consistent
	     * with normal printf behavior. */
	    push_string (low_get_mpz_digits (tmp, 10));
	  else
	    format_dec_frac (tmp, precision);

	  mpz_clear(tmp);
	}
      }
    }
  
  }
/*! @decl protected int(0..1) _is_type(string arg)
   */
  #define f_mpq_cq__is_type_defined

#ifdef f_mpq_cq__is_type_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__is_type_fun_num = 0;

#endif /* f_mpq_cq__is_type_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__is_type(INT32 args) {
#line 622 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct pike_string * str;
#line 622 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("_is_type",args,1);
#line 622 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("_is_type",1,"string");
#line 622 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
debug_malloc_pass(str=Pike_sp[0-1].u.string);
#line 624 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      if( str == literal_float_string )
          do { INT_TYPE ret_=(1); pop_stack(); push_int(ret_); return; }while(0);do { INT_TYPE ret_=(
#line 627 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
0); pop_stack(); push_int(ret_); return; }while(0);
#line 628 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected int|string|float cast(string s)
   *!
   *! Casting to a string returns the number in the decimal fraction
   *! format, where both decimal point and quotient is included only
   *! if required. I.e. it is the same as calling @[get_string] with 1
   *! as argument.
   */
  #define f_mpq_cast_defined

#ifdef f_mpq_cast_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cast_fun_num = 0;

#endif /* f_mpq_cast_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cast(INT32 args) {
#line 637 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct pike_string * s;
#line 637 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 637 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("cast",1,"string");
#line 637 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 639 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
    pop_stack(); /* s have at least one more reference. */
    if( s == literal_int_string )
      f_mpq_get_int(0);
    else if( s == literal_string_string )
      format_string (THISMPQ, 1);
    else if( s == literal_float_string )
      f_mpq_get_float(0);
    else
      push_undefined();
  }

  }
/*! @decl protected Gmp.mpq `+(int|float|object ... a)
   */
    #define f_mpq_cq__backtick_add_defined

#ifdef f_mpq_cq__backtick_add_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_add_fun_num = 0;

#endif /* f_mpq_cq__backtick_add_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_add(INT32 args) {
#line 655 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      for(e=0; e<args; e++)
	get_mpq(sp+e-args, 1, "`+", e + 1, args);
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      for(e=0;e<args;e++)
	mpq_add(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));

      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 666 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected Gmp.mpq ``+(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_backtick_add_defined

#ifdef f_mpq_cq__backtick_backtick_add_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_add_fun_num = 0;

#endif /* f_mpq_cq__backtick_backtick_add_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_add(INT32 args) {
#line 672 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      for(e=0; e<args; e++)
	get_mpq(sp+e-args, 1, "``+", e + 1, args);
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      for(e=0;e<args;e++)
	mpq_add(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 683 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected Gmp.mpq `+=(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_add_eq_defined

#ifdef f_mpq_cq__backtick_add_eq_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_add_eq_fun_num = 0;

#endif /* f_mpq_cq__backtick_add_eq_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_add_eq(INT32 args) {
#line 689 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
    INT32 e;
    for(e=0; e<args; e++)
      get_mpq(sp+e-args, 1, "`+=", e + 1, args);
    for(e=0;e<args;e++)
      mpq_add(THISMPQ, THISMPQ, OBTOMPQ(sp[e-args].u.object));
    
    do { struct object * ret_=(fp->current_object); add_ref(ret_); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 697 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}
  

}
#line 700 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
#ifdef BIG_PIKE_INT
#define TOOBIGTEST || sp[e-args].u.integer>MAX_INT32
#else
#define TOOBIGTEST 
#endif

  static void mult_convert_args(INT32 args, const char *arg_func)
    {
      INT32 e;
      for(e=0; e<args; e++)
      {
	if(TYPEOF(sp[e-args]) == T_OBJECT)
	{
	  if(sp[e-args].u.object->prog == mpzmod_program)
	    continue;

	  if(sp[e-args].u.object->prog == bignum_program)
	    continue;
	}
	
	if(TYPEOF(sp[e-args]) != T_INT || sp[e-args].u.integer<=0 TOOBIGTEST)
	  get_mpq(sp+e-args, 1, arg_func, e + 1, args);
      }
    }
  
  static void mult_args(MP_RAT *res,
			INT32 e,
			INT32 args)
    {
      int norm=0;
      for(;e<args;e++)
      {
	if(TYPEOF(sp[e-args]) == T_INT)
	{
	  mpz_mul_ui(mpq_numref(res),
		      mpq_numref(res),
		      sp[e-args].u.integer);
	  norm++;
	}
	else if(sp[e-args].u.object->prog == mpq_program)
	{
	  mpq_mul(res, res, OBTOMPQ(sp[e-args].u.object));
	}else{
	  norm++;
	  mpz_mul(mpq_numref(res),
		   mpq_numref(res),
		   OBTOMPZ(sp[e-args].u.object));
	}
      }
      
      if(norm) mpq_canonicalize(res);
    }
  
  /*! @decl protected Gmp.mpq `*(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_2A_defined

#ifdef f_mpq_cq__backtick_2A_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_2A_fun_num = 0;

#endif /* f_mpq_cq__backtick_2A_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_2A(INT32 args) {
#line 757 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      struct object *res;
      mult_convert_args(args, "Gmp.mpq->`*");
      
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      mult_args(OBTOMPQ(res), 0,args);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 766 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected Gmp.mpq ``*(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_backtick_2A_defined

#ifdef f_mpq_cq__backtick_backtick_2A_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_2A_fun_num = 0;

#endif /* f_mpq_cq__backtick_backtick_2A_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_2A(INT32 args) {
#line 772 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      struct object *res;
      mult_convert_args(args, "Gmp.mpq->``*");
      
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      mult_args(OBTOMPQ(res), 0,args);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 781 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected Gmp.mpq `-(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_2D_defined

#ifdef f_mpq_cq__backtick_2D_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_2D_fun_num = 0;

#endif /* f_mpq_cq__backtick_2D_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_2D(INT32 args) {
#line 787 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      
      if (args)
	for (e = 0; e<args; e++)
	  get_mpq(sp + e - args, 1, "`-", e + 1, args);
      
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      
      if(args)
      {
	for(e=0;e<args;e++)
	  mpq_sub(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      }else{
	mpq_neg(OBTOMPQ(res), OBTOMPQ(res));
      }
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 807 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected Gmp.mpq ``-(int|float|object sv)
   */
  #define f_mpq_cq__backtick_backtick_2D_defined

#ifdef f_mpq_cq__backtick_backtick_2D_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_2D_fun_num = 0;

#endif /* f_mpq_cq__backtick_backtick_2D_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_2D(INT32 args) {
#line 811 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct svalue * sv;
#line 811 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("``-",args,1);
#line 811 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
sv=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 813 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      struct object *res;
      MP_RAT *a=get_mpq(sv, 1, "``-", 1, args);
      res = fast_clone_object(mpq_program);
      mpq_sub(OBTOMPQ(res), a, THISMPQ);
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 819 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected Gmp.mpq `/(int|float|object ... a)
   */
  #define f_mpq_cq__backtick_2F_defined

#ifdef f_mpq_cq__backtick_2F_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_2F_fun_num = 0;

#endif /* f_mpq_cq__backtick_2F_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_2F(INT32 args) {
#line 825 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      
      for(e=0;e<args;e++)
	if (!mpq_sgn(get_mpq(sp+e-args, 1, "`/", e + 1, args)))
	  SIMPLE_DIVISION_BY_ZERO_ERROR ("`/");
      
      res = fast_clone_object(mpq_program);
      mpq_set(OBTOMPQ(res), THISMPQ);
      for(e=0;e<args;e++)	
	mpq_div(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 839 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}
  
  }
/*! @decl protected Gmp.mpq ``/(int|float|object sv)
   */
  #define f_mpq_cq__backtick_backtick_2F_defined

#ifdef f_mpq_cq__backtick_backtick_2F_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_2F_fun_num = 0;

#endif /* f_mpq_cq__backtick_backtick_2F_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_2F(INT32 args) {
#line 843 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct svalue * sv;
#line 843 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("``/",args,1);
#line 843 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
sv=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 845 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      MP_RAT *a;
      struct object *res = NULL;
      if(!mpq_sgn(THISMPQ))
	SIMPLE_DIVISION_BY_ZERO_ERROR ("``/");

      a=get_mpq(sv, 1, "``/", 1, args);
      
      res=fast_clone_object(mpq_program);
      mpq_div(OBTOMPQ(res), a, THISMPQ);
      
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 857 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected Gmp.mpq `%(int|float|object ... a)
   *! @expr{a%b =  a -  floor(a/b)*b @}
   */
  #define f_mpq_cq__backtick_25_defined

#ifdef f_mpq_cq__backtick_25_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_25_fun_num = 0;

#endif /* f_mpq_cq__backtick_25_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_25(INT32 args) {
#line 864 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      mpq_t tmp;
      
      for(e=0;e<args;e++)
	if (!mpq_sgn(get_mpq(sp+e-args, 1, "`%", e, args)))
	  SIMPLE_DIVISION_BY_ZERO_ERROR ("`%");

      res = fast_clone_object(mpq_program);
      
      mpq_init(tmp);
      mpq_set(OBTOMPQ(res), THISMPQ);
      
      for(e=0;e<args;e++)
      {
	mpz_mul(mpq_numref(tmp),
		mpq_numref(OBTOMPQ(res)),
		mpq_denref(OBTOMPQ(sp[e-args].u.object)));
	
	mpz_tdiv_q(mpq_numref(tmp),
		   mpq_numref(tmp),
		   mpq_denref(tmp));
	
	mpz_tdiv_q(mpq_numref(tmp),
		   mpq_numref(tmp),
		   mpq_numref(OBTOMPQ(sp[e-args].u.object)));
	
	mpz_set_si(mpq_denref(tmp),1);
	
	mpq_mul(tmp, tmp, OBTOMPQ(sp[e-args].u.object));
	mpq_sub(OBTOMPQ(res), OBTOMPQ(res), tmp);
      }
      mpq_clear(tmp);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 900 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected Gmp.mpq ``%(int|float|object a)
   */
  #define f_mpq_cq__backtick_backtick_25_defined

#ifdef f_mpq_cq__backtick_backtick_25_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_backtick_25_fun_num = 0;

#endif /* f_mpq_cq__backtick_backtick_25_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_backtick_25(INT32 args) {
#line 904 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("``%",args,1);
#line 906 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      MP_RAT *a;
      
      struct object *res;
      if(!mpq_sgn(THISMPQ))
	SIMPLE_DIVISION_BY_ZERO_ERROR ("``%");

      a=get_mpq(sp-1, 1, "``%", 1, 1);
      
      res=fast_clone_object(mpq_program);
      
      mpz_mul(mpq_numref(OBTOMPQ(res)), mpq_numref(a), mpq_denref(THISMPQ));
      
      mpz_tdiv_q(mpq_numref(OBTOMPQ(res)),
		 mpq_numref(OBTOMPQ(res)),
		 mpq_denref(OBTOMPQ(res)));
		 
      mpz_tdiv_q(mpq_numref(OBTOMPQ(res)),
		 mpq_numref(OBTOMPQ(res)),
		 mpq_numref(a));
      
      mpz_set_si(mpq_denref(OBTOMPQ(res)),1);
      
      mpq_mul(OBTOMPQ(res), OBTOMPQ(res), THISMPQ);
      mpq_sub(OBTOMPQ(res), a, OBTOMPQ(res));
      
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 933 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl Gmp.mpq invert()
   */
  #define f_mpq_invert_defined

#ifdef f_mpq_invert_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_invert_fun_num = 0;

#endif /* f_mpq_invert_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_invert(INT32 args) {
#line 937 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("invert",args,0);
{
      struct object *res;
      if (!mpq_sgn(THISMPQ))
	SIMPLE_DIVISION_BY_ZERO_ERROR ("invert");
      res = fast_clone_object(mpq_program);
      mpq_inv(OBTOMPQ(res), THISMPQ);
      do { struct object * ret_=(res);  push_object(ret_); return; }while(0);
#line 945 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}
  
  }
/*! @decl protected Gmp.mpq `~()
   *! Defined as @expr{-1-x@}.
   */
  #define f_mpq_cq__backtick_7E_defined

#ifdef f_mpq_cq__backtick_7E_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_7E_fun_num = 0;

#endif /* f_mpq_cq__backtick_7E_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_7E(INT32 args) {
#line 950 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("`~",args,0);
#line 952 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      struct object *o;
      o=fast_clone_object(mpq_program);
      mpq_set_si(OBTOMPQ(o), -1, 1);
      mpq_sub(OBTOMPQ(o),OBTOMPQ(o), THISMPQ);
      
      do { struct object * ret_=(o);  push_object(ret_); return; }while(0);
#line 959 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected int(0..1) `>(mixed q)
   */
  #define f_mpq_cq__backtick_3E_defined

#ifdef f_mpq_cq__backtick_3E_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_3E_fun_num = 0;

#endif /* f_mpq_cq__backtick_3E_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_3E(INT32 args) {
#line 963 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 963 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`>",args,1);
#line 963 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 965 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1, "`>", 1, args)) > 0); pop_stack(); push_int(ret_); return; }while(0);
#line 967 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected int(0..1) `<(mixed q)
   */
  #define f_mpq_cq__backtick_3C_defined

#ifdef f_mpq_cq__backtick_3C_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_3C_fun_num = 0;

#endif /* f_mpq_cq__backtick_3C_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_3C(INT32 args) {
#line 971 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 971 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`<",args,1);
#line 971 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 973 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1, "`<", 1, args)) < 0); pop_stack(); push_int(ret_); return; }while(0);
#line 975 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}


  }
/*! @decl protected int(0..1) `==(mixed q)
   */
  #define f_mpq_cq__backtick_eq_eq_defined

#ifdef f_mpq_cq__backtick_eq_eq_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_eq_eq_fun_num = 0;

#endif /* f_mpq_cq__backtick_eq_eq_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_eq_eq(INT32 args) {
#line 980 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 980 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`==",args,1);
#line 980 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 982 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
    MP_RAT *arg=get_mpq(q, 0, NULL, 0, 0);
    do { INT_TYPE ret_=(arg && !mpq_cmp(THISMPQ, arg)); pop_stack(); push_int(ret_); return; }while(0);
#line 985 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl int(-1..1) sgn()
   */
  #define f_mpq_sgn_defined

#ifdef f_mpq_sgn_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_sgn_fun_num = 0;

#endif /* f_mpq_sgn_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_sgn(INT32 args) {
#line 989 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("sgn",args,0);
{
      do { INT_TYPE ret_=(mpq_sgn(THISMPQ));  push_int(ret_); return; }while(0);
#line 992 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }
/*! @decl protected int(0..1) `!(mixed q)
   */
  #define f_mpq_cq__backtick_21_defined

#ifdef f_mpq_cq__backtick_21_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_mpq_cq__backtick_21_fun_num = 0;

#endif /* f_mpq_cq__backtick_21_fun_num_used */
DEFAULT_CMOD_STORAGE void f_mpq_cq__backtick_21(INT32 args) {
#line 996 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
#line 998 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(!mpq_sgn(THISMPQ));  push_int(ret_); return; }while(0);
#line 1000 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

  }

#undef internal_init_mpq_defined
#define internal_init_mpq_defined

#undef mpq_event_handler_defined
#define mpq_event_handler_defined
static void init_mpq_struct(void)
#line 1003 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
#ifdef PIKE_DEBUG
      if(!fp) Pike_fatal("ZERO FP\n");
      if(!THISMPQ) Pike_fatal("ZERO THISMPQ\n");
#endif
      mpq_init(THISMPQ);
    }
  
  
#undef internal_exit_mpq_defined
#define internal_exit_mpq_defined

#undef mpq_event_handler_defined
#define mpq_event_handler_defined
static void exit_mpq_struct(void)
#line 1013 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
#ifdef PIKE_DEBUG
      if(!fp) Pike_fatal("ZERO FP\n");
      if(!THISMPQ) Pike_fatal("ZERO THISMPQ\n");
#endif
      mpq_clear(THISMPQ);
    }

  
#undef internal_gc_recurse_mpq_defined
#define internal_gc_recurse_mpq_defined

#undef mpq_event_handler_defined
#define mpq_event_handler_defined
static void gc_recurse_mpq_struct(void)
#line 1022 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
{
    if (mc_count_bytes (Pike_fp->current_object))
      mc_counted_bytes +=
#ifdef MPZ_T_HAS__MP_ALLOC
	mpq_numref (THISMPQ)[0]._mp_alloc * sizeof (mp_limb_t) +
	mpq_denref (THISMPQ)[0]._mp_alloc * sizeof (mp_limb_t) +
#else
	mpz_size (mpq_numref (THISMPQ)) * sizeof (mp_limb_t) +
	mpz_size (mpq_denref (THISMPQ)) * sizeof (mp_limb_t) +
#endif
	sizeof (mpq_t);
  }

#ifdef mpq_event_handler_defined
static void mpq_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_mpq_defined
  case PROG_EVENT_INIT: init_mpq_struct(); break;

#endif /* internal_init_mpq_defined */

#ifdef internal_exit_mpq_defined
  case PROG_EVENT_EXIT: exit_mpq_struct(); break;

#endif /* internal_exit_mpq_defined */

#ifdef internal_gc_recurse_mpq_defined
  case PROG_EVENT_GC_RECURSE: gc_recurse_mpq_struct(); break;

#endif /* internal_gc_recurse_mpq_defined */
  default: break; 
  }
}

#endif /* mpq_event_handler_defined */
/*! @endclass
 */

/*! @endmodule
 */

#line 1042 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
#endif /* USE_GMP */


void pike_init_mpq_module(void)
{
  
#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( ___cmod_map_program_ids );

#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */

#ifdef class_mpq_defined

#ifdef PROG_MPQ_ID
#line 64 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
  START_NEW_PROGRAM_ID(MPQ);
#else
#line 64 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
  start_new_program();

#endif /* PROG_MPQ_ID */
#line 64 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
  mpq_program = Pike_compiler->new_program;

#ifndef tObjImpl_MPQ

#undef tObjIs_MPQ
#define tObjIs_MPQ "\3\1\177\0\0\2"

#undef tObjImpl_MPQ
#define tObjImpl_MPQ "\3\0\177\0\0\2"

#endif /* tObjImpl_MPQ */

#ifdef THIS_MPQ
  mpq_storage_offset = ADD_STORAGE(struct mpq_struct);
#endif /* THIS_MPQ */

#ifdef mpq_event_handler_defined
  pike_set_prog_event_callback(mpq_event_handler);

#ifndef mpq_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* mpq_gc_live_obj */

#endif /* mpq_event_handler_defined */

#ifdef f_mpq_create_defined

#ifdef f_mpq_create_fun_num_used
  f_mpq_create_fun_num =
#endif /* f_mpq_create_fun_num_used */
#line 279 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("create", f_mpq_create, tOr3(tFunc(tOr5(tVoid,tStr,"\10\200\0\0\0\177\377\377\377",tFloat,tObj),tVoid),tFunc(tStr "\10\200\0\0\0\177\377\377\377",tVoid),tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tVoid)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_create_defined */

#ifdef f_mpq_get_int_defined

#ifdef f_mpq_get_int_fun_num_used
  f_mpq_get_int_fun_num =
#endif /* f_mpq_get_int_fun_num_used */
#line 338 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("get_int", f_mpq_get_int, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_get_int_defined */

#ifdef f_mpq_cq___hash_defined

#ifdef f_mpq_cq___hash_fun_num_used
  f_mpq_cq___hash_fun_num =
#endif /* f_mpq_cq___hash_fun_num_used */
#line 348 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("__hash", f_mpq_cq___hash, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq___hash_defined */

#ifdef f_mpq_get_float_defined

#ifdef f_mpq_get_float_fun_num_used
  f_mpq_get_float_fun_num =
#endif /* f_mpq_get_float_fun_num_used */
#line 358 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("get_float", f_mpq_get_float, tFunc(tNone,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_get_float_defined */

#ifdef f_mpq_get_string_defined

#ifdef f_mpq_get_string_fun_num_used
  f_mpq_get_string_fun_num =
#endif /* f_mpq_get_string_fun_num_used */
#line 522 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("get_string", f_mpq_get_string, tFunc(tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),tStr), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_get_string_defined */

#ifdef f_mpq_num_defined

#ifdef f_mpq_num_fun_num_used
  f_mpq_num_fun_num =
#endif /* f_mpq_num_fun_num_used */
    ADD_FUNCTION2("num", f_mpq_num, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_num_defined */

#ifdef f_mpq_den_defined

#ifdef f_mpq_den_fun_num_used
  f_mpq_den_fun_num =
#endif /* f_mpq_den_fun_num_used */
#line 542 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("den", f_mpq_den, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_den_defined */

#ifdef f_mpq_cq__sprintf_defined

#ifdef f_mpq_cq__sprintf_fun_num_used
  f_mpq_cq__sprintf_fun_num =
#endif /* f_mpq_cq__sprintf_fun_num_used */
#line 573 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("_sprintf", f_mpq_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tStr), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__sprintf_defined */

#ifdef f_mpq_cq__is_type_defined

#ifdef f_mpq_cq__is_type_fun_num_used
  f_mpq_cq__is_type_fun_num =
#endif /* f_mpq_cq__is_type_fun_num_used */
#line 622 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("_is_type", f_mpq_cq__is_type, tFunc(tStr,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__is_type_defined */

#ifdef f_mpq_cast_defined

#ifdef f_mpq_cast_fun_num_used
  f_mpq_cast_fun_num =
#endif /* f_mpq_cast_fun_num_used */
#line 637 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("cast", f_mpq_cast, tFunc(tStr,tOr3("\10\200\0\0\0\177\377\377\377",tStr,tFloat)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cast_defined */

#ifdef f_mpq_cq__backtick_add_defined

#ifdef f_mpq_cq__backtick_add_fun_num_used
  f_mpq_cq__backtick_add_fun_num =
#endif /* f_mpq_cq__backtick_add_fun_num_used */
#line 653 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`+", f_mpq_cq__backtick_add, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_add_defined */

#ifdef f_mpq_cq__backtick_backtick_add_defined

#ifdef f_mpq_cq__backtick_backtick_add_fun_num_used
  f_mpq_cq__backtick_backtick_add_fun_num =
#endif /* f_mpq_cq__backtick_backtick_add_fun_num_used */
#line 670 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``+", f_mpq_cq__backtick_backtick_add, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_add_defined */

#ifdef f_mpq_cq__backtick_add_eq_defined

#ifdef f_mpq_cq__backtick_add_eq_fun_num_used
  f_mpq_cq__backtick_add_eq_fun_num =
#endif /* f_mpq_cq__backtick_add_eq_fun_num_used */
#line 687 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`+=", f_mpq_cq__backtick_add_eq, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_add_eq_defined */

#ifdef f_mpq_cq__backtick_2A_defined

#ifdef f_mpq_cq__backtick_2A_fun_num_used
  f_mpq_cq__backtick_2A_fun_num =
#endif /* f_mpq_cq__backtick_2A_fun_num_used */
#line 755 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`*", f_mpq_cq__backtick_2A, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2A_defined */

#ifdef f_mpq_cq__backtick_backtick_2A_defined

#ifdef f_mpq_cq__backtick_backtick_2A_fun_num_used
  f_mpq_cq__backtick_backtick_2A_fun_num =
#endif /* f_mpq_cq__backtick_backtick_2A_fun_num_used */
#line 770 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``*", f_mpq_cq__backtick_backtick_2A, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_2A_defined */

#ifdef f_mpq_cq__backtick_2D_defined

#ifdef f_mpq_cq__backtick_2D_fun_num_used
  f_mpq_cq__backtick_2D_fun_num =
#endif /* f_mpq_cq__backtick_2D_fun_num_used */
#line 785 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`-", f_mpq_cq__backtick_2D, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2D_defined */

#ifdef f_mpq_cq__backtick_backtick_2D_defined

#ifdef f_mpq_cq__backtick_backtick_2D_fun_num_used
  f_mpq_cq__backtick_backtick_2D_fun_num =
#endif /* f_mpq_cq__backtick_backtick_2D_fun_num_used */
#line 811 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``-", f_mpq_cq__backtick_backtick_2D, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_2D_defined */

#ifdef f_mpq_cq__backtick_2F_defined

#ifdef f_mpq_cq__backtick_2F_fun_num_used
  f_mpq_cq__backtick_2F_fun_num =
#endif /* f_mpq_cq__backtick_2F_fun_num_used */
#line 823 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`/", f_mpq_cq__backtick_2F, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2F_defined */

#ifdef f_mpq_cq__backtick_backtick_2F_defined

#ifdef f_mpq_cq__backtick_backtick_2F_fun_num_used
  f_mpq_cq__backtick_backtick_2F_fun_num =
#endif /* f_mpq_cq__backtick_backtick_2F_fun_num_used */
#line 843 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``/", f_mpq_cq__backtick_backtick_2F, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_2F_defined */

#ifdef f_mpq_cq__backtick_25_defined

#ifdef f_mpq_cq__backtick_25_fun_num_used
  f_mpq_cq__backtick_25_fun_num =
#endif /* f_mpq_cq__backtick_25_fun_num_used */
#line 862 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`%", f_mpq_cq__backtick_25, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_25_defined */

#ifdef f_mpq_cq__backtick_backtick_25_defined

#ifdef f_mpq_cq__backtick_backtick_25_fun_num_used
  f_mpq_cq__backtick_backtick_25_fun_num =
#endif /* f_mpq_cq__backtick_backtick_25_fun_num_used */
#line 904 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("``%", f_mpq_cq__backtick_backtick_25, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_25_defined */

#ifdef f_mpq_invert_defined

#ifdef f_mpq_invert_fun_num_used
  f_mpq_invert_fun_num =
#endif /* f_mpq_invert_fun_num_used */
#line 937 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("invert", f_mpq_invert, tFunc(tNone,tName("mpq", tObjImpl_MPQ)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_invert_defined */

#ifdef f_mpq_cq__backtick_7E_defined

#ifdef f_mpq_cq__backtick_7E_fun_num_used
  f_mpq_cq__backtick_7E_fun_num =
#endif /* f_mpq_cq__backtick_7E_fun_num_used */
#line 950 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`~", f_mpq_cq__backtick_7E, tFunc(tNone,tName("mpq", tObjImpl_MPQ)), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_7E_defined */

#ifdef f_mpq_cq__backtick_3E_defined

#ifdef f_mpq_cq__backtick_3E_fun_num_used
  f_mpq_cq__backtick_3E_fun_num =
#endif /* f_mpq_cq__backtick_3E_fun_num_used */
#line 963 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`>", f_mpq_cq__backtick_3E, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3E_defined */

#ifdef f_mpq_cq__backtick_3C_defined

#ifdef f_mpq_cq__backtick_3C_fun_num_used
  f_mpq_cq__backtick_3C_fun_num =
#endif /* f_mpq_cq__backtick_3C_fun_num_used */
#line 971 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`<", f_mpq_cq__backtick_3C, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3C_defined */

#ifdef f_mpq_cq__backtick_eq_eq_defined

#ifdef f_mpq_cq__backtick_eq_eq_fun_num_used
  f_mpq_cq__backtick_eq_eq_fun_num =
#endif /* f_mpq_cq__backtick_eq_eq_fun_num_used */
    ADD_FUNCTION2("`==", f_mpq_cq__backtick_eq_eq, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_eq_eq_defined */

#ifdef f_mpq_sgn_defined

#ifdef f_mpq_sgn_fun_num_used
  f_mpq_sgn_fun_num =
#endif /* f_mpq_sgn_fun_num_used */
    ADD_FUNCTION2("sgn", f_mpq_sgn, tFunc(tNone,"\10\377\377\377\377\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_sgn_defined */

#ifdef f_mpq_cq__backtick_21_defined

#ifdef f_mpq_cq__backtick_21_fun_num_used
  f_mpq_cq__backtick_21_fun_num =
#endif /* f_mpq_cq__backtick_21_fun_num_used */
#line 996 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    ADD_FUNCTION2("`!", f_mpq_cq__backtick_21, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_21_defined */
#line 64 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
  mpq_program=end_program();
#line 64 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
#ifdef mpq_program_fun_num_used
mpq_program_fun_num=
#endif
 add_program_constant("mpq",mpq_program,0);

#endif /* class_mpq_defined */

#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( 0 );
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
#line 1048 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}

void pike_exit_mpq_module(void)
{
  
#ifdef class_mpq_defined
  if(mpq_program) {
#line 64 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
    free_program(mpq_program);
    mpq_program=0;
  }

#endif /* class_mpq_defined */
#line 1053 "/home/zino/hack/pike8-rel/pike/src/modules/Gmp/mpq.cmod"
}


#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
static int ___cmod_map_program_ids(int id)
{
  int i = 0;
  if( (id&0x7f000000) != 0x7f000000 ) return id;
  id = id&0x00ffffff;
#ifdef class_mpq_defined
if(id==2) return mpq_program->id;
#endif
  return 0;
}
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
