/* test.pike
 *
 */

import .types;

string cert =
#"-----BEGIN CERTIFICATE-----
MIIBijCCATQCAQAwDQYJKoZIhvcNAQEEBQAwUDELMAkGA1UEBhMCc2UxEjAQBgNV
BAcTCUxpbmtvcGluZzESMBAGA1UEChMJSWRvbmV4IEFCMQ0wCwYDVQQLEwRUZXN0
MQowCAYDVQQDFAEqMB4XDTk4MDgyNTA4MDcxN1oXDTk4MDkyNDA4MDcxN1owUDEL
MAkGA1UEBhMCc2UxEjAQBgNVBAcTCUxpbmtvcGluZzESMBAGA1UEChMJSWRvbmV4
IEFCMQ0wCwYDVQQLEwRUZXN0MQowCAYDVQQDFAEqMFwwDQYJKoZIhvcNAQEBBQAD
SwAwSAJBANSUiqFOOCOfjHXfLy5ne3avnq3Dzeb+LKL0DULEnmoNd8UAt76B8sxv
6KDXgTGCqZQo2NrdyYtUFgOPAkgRYG8CAwEAATANBgkqhkiG9w0BAQQFAANBAI/G
yQA8avNbqYfDRH/AoPAQGKeK6A0e+zMANeZfkttk8qvvtrlzkivFC4WxqDE7Zol0
VHCAYiYfn2QpQx2e4/g=
-----END CERTIFICATE-----
";

string key =
#"-----BEGIN RSA PRIVATE KEY-----
MIIBOgIBAAJBANSUiqFOOCOfjHXfLy5ne3avnq3Dzeb+LKL0DULEnmoNd8UAt76B
8sxv6KDXgTGCqZQo2NrdyYtUFgOPAkgRYG8CAwEAAQJAWvjOcsVUhPosU+0U9djX
Hy18zIP0w5uWYo3qdt5JpLwjAVAPlFgWeAoHiIhZMXekRm+byXqawRywYs0KsUra
IQIhAO8cfuCcHUiSh6h7trq3UFQchu5m5sDQ6Y/tE6BxLFupAiEA45hSqNDdv2uA
4/wpy89HZz9n6lViELVh8rt20qggqlcCIQDMqJk4aqbt3O1cGje27PxGYfxjxZOw
aZ/f3s2zv+p1sQIgf+tmUjIK4ILoz7s0NrRK+rH9kwzocGGyKr7I2z/aFEMCICBY
ilLNhXR2OAbhZzC1H8Y6xdvP7J3yQQbjPadY8rPE
-----END RSA PRIVATE KEY-----
";

class dummy_mailbox
{
  string headers =
#"X-From-Line: klockmaster-import@idonex.se Thu Mar 19 15:58 MET 1998
Received: from skuld (nisse@yume [194.52.182.55])
          by jolt.idonex.se (8.8.5/8.8.4) with ESMTP
	  id PAA04118 for nisse@idonex.se; Thu, 19 Mar 1998 15:58:32 +0100 (MET)
Date: Thu, 19 Mar 1998 15:58:32 +0100 (MET)
From: klockmaster-import@idonex.se
Message-Id: <199803191458.PAA04118@jolt.idonex.se>
To: nisse@idonex.se
Subject: Din bestllning hos Klockmster. %&#* 9 FkSrXGas3DYDNkvj2E0jT *#&%
MIME-Version: 1.0
Content-Type: multipart/mixed;boundary=ThIs-RaNdOm-StRiNg
X-Content-Length: 17993
Lines: 270
Xref: hiro.idonex.se mail.misc:693
";

  string body =
#"[ Eftersom du lser det hr, frstr din maillsare
  antagligen inte MIME. Du kan ignorera bilagorna, 
  de innehller den hr texten en gng till, samt
  en bild p den klocka du bestllt. ]

Svara p det hr brevet, utan att ta bort nyckeln
frn renderaden, fr att bekrfta bestllningen.


Din bestllning: 

Artikelnummer: 17
Pris: 1.995

Namn: nisse
Address: skolgata
         linkboda


--ThIs-RaNdOm-StRiNg
Content-Transfer-Encoding: 8bit
Content-Length: 201
Content-Type: text/plain; charset=iso-8859-1
MIME-Version: 1.0

Svara p det hr brevet, utan att ta bort nyckeln
frn renderaden, fr att bekrfta bestllningen.


Din bestllning: 

Artikelnummer: 17
Pris: 1.995

Namn: nisse
Address: skolgata
         linkboda


--ThIs-RaNdOm-StRiNg
Content-Transfer-Encoding: base64
Content-Length: 17286
Content-Type: image/gif
MIME-Version: 1.0
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--ThIs-RaNdOm-StRiNg--
";

  int deleted = 0;

  int uidvalidity = time();
  
  array get_flags()
    {
      return ({ "FLAGS", imap_list(
	({ "\\Answered", "\\Flagged", "\\Deleted", "\\Seen", "\\Draft", "foo" }) ) });
    }

  array get_exists()
    {
      return ({ "1", "EXISTS" });
    }

  array get_recent()
    {
      return ({ "1", "RECENT"});
    }

  array get_unseen()
    {
      return ({ "OK", imap_prefix( ({ "UNSEEN", imap_number(1) }) ) });
    }

  array get_permanent_flags()
    {
      return ({ "OK", imap_prefix( ({ "PERMANENTFLAGS",
				      imap_list( ({ "foo" }) ) }) ) });
    }

  array get_uidvalidity()
    {
      return ({ "OK", imap_prefix( ({ "UIDVALIDITY",
				      imap_number(uidvalidity) }) ) });
    }
}

class backend
{
  int login(object|mapping session, string user, string passwd)
    {
      werror("login: %O:%O\n", user, passwd);
      session->uid = user;
      return 1;
    }

  array capabilities(object|mapping session)
    {
      werror("capability\n");
      return ({ "IMAP4rev1" });
    }

  array update(object|mapping session)
    {
      werror("update\n");
      return 0;
    }

  array list(object|mapping session, string reference, string glob)
    {
      if ( (reference != "") )
	return ({ });
      switch(glob)
      {
      case "INBOX":
      case "*":
      case "%":
	return ({ ({ imap_list( ({}) ), "nil", "INBOX" }) });
      default:
	return ({});
      }
    }

  array lsub(object|mapping session, string reference, string glob)
    {
      return list(session, reference, glob);
    }

  array select(object|mapping session, string mailbox)
    {
      if (mailbox != "INBOX")
      {
	session->mailbox = 0;
	return 0;
      }
      object m = dummy_mailbox();
      
      session->mailbox = m();
      return ({ m->get_uidvalidity(),
		m->get_exists(),
		m->get_recent(),
		m->get_unseen(),
		m->get_flags(),
		m->get_permanent_flags() });
    }
  /* HERE
   *
   * Next command for pine: A00003 FETCH 1:1 ALL
   *                        A00004 SEARCH DELETED
   * Next command for netscape: 6 create "Trash"
   */
}

int main(int argc, array(string) argv)
{
  int portnr = (argc == 2) ? (int) argv[1] : 143;

  .imap_server(Stdio.Port(), portnr, 600, backend(), 1);

  return -17;
}

