# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding unit tests
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

from pgm_test_case import PgmTestCase
import pgm


class _TestDrawable(PgmTestCase):

    def setUp(self):
        # please set self.drawable
        PgmTestCase.setUp(self)

    def tearDown(self):
        if hasattr(self, 'drawable'):
            del self.drawable
        PgmTestCase.tearDown(self)


    def test_visibility(self):
        # hide
        self.drawable.hide()
        self.assertEqual(self.drawable.is_visible(), False)

        # show
        self.drawable.show()
        self.assertEqual(self.drawable.is_visible(), True)

    def test_size(self):

        size = self.drawable.get_size()

        new_size = (50, 60.)
        self.drawable.set_size(*new_size)
        self.assertEqual(self.drawable.get_size(), new_size)

    def test_position(self):

        # get
        position = self.drawable.get_position()
        self.failUnless(isinstance(position, tuple))
        self.assertEqual(len(position), 3)

        self.assertEqual(position, (0., 0., 0.))

        # set
        new_pos = (1, 2, 3.5)
        self.drawable.set_position(*new_pos)
        self.assertEqual(self.drawable.get_position(), new_pos)

    # TODO: move to test_image
##     def test_alignment(self):

##         # get
##         align = self.drawable.get_alignment()
##         self.assertEqual(align, pgm.DrawableAlignment(pgm.DRAWABLE_CENTER))

##         # set
##         new_align = pgm.DrawableAlignment(pgm.DRAWABLE_LEFT)
##         self.drawable.set_alignment(new_align)
##         self.assertEqual(self.drawable.get_alignment(), new_align)

    def test_fg_color(self):

        # get
        fg_color = self.drawable.get_fg_color()
        self.assertEqual(fg_color, (255, 255, 255, 255))

        # set
        new_color = (128, 254, 34, 45)
        self.drawable.set_fg_color(*new_color)
        self.assertEqual(self.drawable.get_fg_color(), new_color)

    def test_bg_color(self):

        # get
        bg_color = self.drawable.get_bg_color()
        self.assertEqual(bg_color, (255, 255, 255, 255))

        # set
        new_color = (128, 254, 34, 45)
        self.drawable.set_bg_color(*new_color)
        self.assertEqual(self.drawable.get_bg_color(), new_color)

    def test_opacity(self):

        # get
        opacity = self.drawable.get_opacity()
        self.assertEqual(opacity, 255)

        # set
        new_opacity = 128
        self.drawable.set_opacity(new_opacity)
        self.assertEqual(self.drawable.get_opacity(), new_opacity)
